package BM::YT::YTTable;
use strict;

use utf8;
use open ':utf8';

use base qw(ObjLib::ProjPart);

use BM::YT::Client;
use Data::Dumper;

__PACKAGE__->mk_accessors(qw(
    path
    columns
    schema
    sort_by
));

sub init {
}

sub yt_client {
    my ($self) = @_;
    return $self->proj->yt_client();
}

sub format {
    my ($self) = @_;
    #return $self->{format} if $self->{format};
    return "<columns=[" . join(";", @{$self->columns}) . ";];missing_value_mode=print_sentinel;enable_escaping=true>schemaful_dsv";
}

# Example:
#   my $yttbl = BM::YT::YTTable->new({
#           proj => $proj,
#           path => "//home/broadmatching/bnr_word_fullindex/bid-normword.word_sorted",
#           columns => [qw[ bid word ]],
#   });
#   my $list1 = $yttbl->ListByID("ъъ");
#   my $list2 = $yttbl->ListByID(undef, range => ["ъъ", "ъь"]);
sub ListByID {
    my ($self, $id, %prm) = @_;

    my $quote = sub {
        my ($id, $type) = @_;
        $type //= '';
        if ($type eq 'string') {
            return qq!"$id"!;
        } elsif ($type eq 'uint64') {
            return $id.'u';
        } elsif ($type eq 'int64') {
            return $id;
        } else {
            return $id;
        }
    };

    my $format = sub {
        my ($id) = @_;
        my %fld2type = map { $_->{name} => $_->{type} } @{ $self->schema || [] };
        my @types = map { $fld2type{$_} } @{ $self->sort_by || [] };
        my @id_arr = ref($id) eq 'ARRAY' ? @$id : ($id);
        my @id_types;
        for my $i (0 .. $#id_arr) {
            push @id_types, [ $id_arr[$i], $types[$i] ];
        }
        return "(" . join(",", map { $quote->( @{$_} ) } @id_types) . ")";
    };

    my $range = defined $id ? $format->($id) : $format->($prm{range}[0]) . ':' . $format->($prm{range}[1]);
    my $output = $self->yt_client->read_cmd(join(" ",
            "read",
            "'" . $self->path . "[$range]" . "'",
            ($self->format ? "--format='".$self->format."'" : ()),
    ));
    my $list = [];
    my @columns = @{ $self->columns || [ map { $_->{name} } $self->schema ] };
    for my $line (split /\r?\n/, $output) {
        my %h;
        @h{@columns} = split /\t/, $line;
        push @$list, \%h;
    }
    return $list;
}

1;
