package BM::Zora;

use strict;

use 5.010;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN, ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");
use Encode qw/:all/;
use List::Util qw(min);
use Scalar::Util qw(reftype);

use base qw(ObjLib::ProjPart);

use Data::Dumper;
$Data::Dumper::Useqq = 1;
use Time::HiRes qw/gettimeofday tv_interval/;
use Utils::Common;
use Utils::Words;
use HTTP::Request;

use File::Copy;
use File::Temp qw(tempdir);
use File::Path qw(rmtree);
use Utils::Sys qw(make_good_utf_string get_tempfile);
use Utils::Funcs qw(content_is_text);

# CACHED - UNCACHED
sub multi_get_hashref {
    my ( $self, $urls_arrayref, $params ) = @_;
    if ( $self->{use_kyoto_cache} ) {
        return $self->multi_get_extras_cached( $urls_arrayref, $params );
    } else {
        return $self->multi_get_extras_uncached( $urls_arrayref, $params );
    }
}

sub multi_get_extras : KYOTOCACHEHASHREF(86400) {
    my ( $self, $urls_arrayref, $params ) = @_;
    return $self->_multi_get_extras( $urls_arrayref, $params );
}

sub multi_get_extras_uncached {
    my ( $self, $urls_arrayref, $params ) = @_;
    return $self->_multi_get_extras( $urls_arrayref, $params );
}
# /CACHED - UNCACHED

# в случае превышения квоты время сна быстро увеличивается, а если квота не превышена - медленно падает
sub throttle {
    my ($self, $response_params) = @_;

    $self->{_throttle} //= 0;

    my $quota_exceeded = 0;
    if ( $response_params->{reason} && $response_params->{reason} =~ /quota exceeded/ ) {
        $quota_exceeded = 1;
    }

    my $throttle_ratio = 20;

    if ($quota_exceeded) {
        $self->{_throttle} += $throttle_ratio;
    }
    elsif ( $self->{_throttle} > 0 ) {
        $self->{_throttle} -= 1;
    }

    my $sleep_time = int( $self->{_throttle} / $throttle_ratio );
    if ( $sleep_time ) {
        $self->proj->log("zora throttle activated, sleep $sleep_time seconds per url");
        sleep($sleep_time);
    }
}

# like multiget with additions
sub _multi_get_extras {
    my ( $self, $urls_arrayref, $params ) = @_;

    #здесь могут быть как просто урлы, так и hashref или объекты page
    my @elems = @$urls_arrayref;
    #сюда складываем урлы при обработке
    my @urls = ();
    my $url_params = {};

    if ($ENV{BM_DISABLE_EXTERNAL_INTERNET}) {
        $self->proj->log("DISABLE_EXTERNAL_INTERNET for _multi_get_extras ");
        return;
    }
    # во временный файл
    my $temp_file = get_tempfile('temp_urls', DIR => $self->{temp_dir}, UNLINK => 1);
    my $temp_file2 = get_tempfile('temp_urls_result', DIR => $self->{temp_dir}, UNLINK => 1);

    open (tF,">$temp_file") or $self->log("ERROR: cannot open file, $!");
    for my $elem ( @elems) {
        if ( $elem ) {
            my $url;
            my $request;
            if ( defined reftype($elem) and reftype($elem) eq 'HASH' ) {
                # это или объект Page, или хэш

                # добавляем урл
                $url = $elem->{url};
                next unless $url;

                $request = $url;
                my $http_req = HTTP::Request->new(GET => $url);
                $self->{custom_cookies}->add_cookie_header($http_req);
                my $cookies = $http_req->header("cookie");
                if ($cookies) {
                    for my $cookie (split /;/, $cookies) {
                        $cookie =~ s/\s+//;
                        $request .= " header=Cookie:" . $cookie;
                    }
                }

                if ( exists $elem->{login} && exists $elem->{pass} ) {
                    # добавляем базовую аутентификацию в запрос
                    my $login = $elem->{login} // '';
                    my $password = $elem->{pass} // '';
                    if ( ( $login =~ /\s/ ) || ( $password =~ /\s/ ) ) {
                        $self->log("WARNING: whitespace in auth credentials is not supported by zoracl, falling back to unauthorized request: $url");
                    }
                    else {
                        # все проверки пройдены, можно добавлять
                        $request .= " login=$login password=$password";
                    }
                }
                if ($elem->{result_file}) {
                    $url_params->{$elem->{url}}{result_file} = $elem->{result_file};
                }
            }
            elsif ( !reftype($elem) ) {
                # это скаляр, делаем простой запрос
                $url = $elem;
                $request = $url;
            }

            if ( $url ) {
                push @urls, $url;
                print tF $request . "\n";
            }
        }
    }
    close tF;

    # timeout case
    my $timeout = ( defined($params) && ref($params) eq 'HASH' && exists($params->{timeout}) && int($params->{timeout}) > 0 ) ? $params->{timeout} : $self->{default_timeout};

    if ( !defined($timeout) || !$timeout ) {
        $self->log("WARNING: timeout not set, continue with 14400 timeout");
        $timeout = 14400;
    }

    # во временный файл
    my $url_hash = { map { $_ => 1 } grep { $_ !~ /^\s*$/ } @urls };

    my ( $domain_first_url ) = ( $urls[0] =~ /^https?:\/\/([^\?:\/\\\\\#]+)/ );
    if ( !defined($domain_first_url) || !$domain_first_url ) {
        $self->log("ERROR: bad urls in input:[" . join(',', @urls) . "]") unless $params->{no_error};
        unlink $temp_file;
        unlink $temp_file2;
        return;
    }

    $self->log("get zora for urls:" . scalar(@urls));
    my $ztime = [gettimeofday];
    my $ext_timeout = $timeout + min(2, int($timeout / 3));
    my $zoracl_temp_dir = File::Temp::tempdir("zoracl_tmp.$$.XXXX", DIR => $self->{temp_dir}, CLEANUP => 1);

    my $command = $self->{multiget_command} . " --input=$temp_file --output=$temp_file2 --timeout=$timeout --tempdir=$zoracl_temp_dir";
    if ( $params->{zora_big_files} ) {
        $command .= ' --use-range-download --aggregate-range-download --range-download-chunk-size=10485760';
    }

    my $tvm_clientid;
    my $tvm_secret;
    if ( !exists $ENV{TVM_CLIENTID} or !exists $ENV{TVM_SECRET} ) {
        for my $secret_file ( @{ $self->{tvm}{secret_locations} // [] } ) {
            if ( -s $secret_file ) {
                $tvm_clientid = $self->{tvm}{clientid};
                open TVMF, '<', $secret_file or die("Cannot open $secret_file : $!\n");
                $tvm_secret = <TVMF>;
                close TVMF;
                chomp $tvm_secret;
                last;
            }
        }
    }
    local $ENV{TVM_CLIENTID} = $tvm_clientid if defined $tvm_clientid;
    local $ENV{TVM_SECRET} = $tvm_secret if defined $tvm_secret;

    if ( !exists $ENV{TVM_CLIENTID} or !exists $ENV{TVM_SECRET} ) {
        $self->log("WARNING: tvm token for zoracl not specified");
    }

    my $is_download_successful = $self->do_sys_cmd($command, no_error => $params->{no_error}, no_die => 1, timeout => $ext_timeout, kill_after => 10);
    rmtree($zoracl_temp_dir);
    # обработка ошибок: или исключение, или падение по таймауту. В обоих случаях в ретраях нет смысла
    if (!$is_download_successful) {
        unlink $temp_file;
        unlink $temp_file2;
        return {map { $_ => {download_error => 'FATAL_NORETRY'} } @urls};
    }

    $self->log( join("\t",
        "ZDEBUG:",
        "domain:[$domain_first_url]",
        "urls:[" . scalar(@urls) . "]",
        "time:" . tv_interval($ztime),
        "urls per second:" . sprintf("%.2f", scalar(@urls) / (tv_interval($ztime) + 0.001))
    )) if $params->{debug};

    $self->log("done get zora for urls:" . scalar(@urls));

    my $total_size = 0;
    my $current_url = 0;
    my $result = {};
    my $httpcode = "";
    open (fF,"<$temp_file2") or $self->log("ERROR: cannot fetch");
    binmode(fF,":bytes");
    while (!eof(fF)) {
        my $line = <fF>; chomp($line);
        eval {
            $line = $self->proj->detect_charset->text2utf8($line);  # Т.к. в урле может быть кириллица
        };
        $self->log('zora response line: '. $line);
        my ( $result_urls_str, @others ) = split /[\t]/, $line;
        my @result_urls_arr = split /\s+/, $result_urls_str;

        my $first = $result_urls_arr[0];
        my $last = $result_urls_arr[-1];

        if ( $last eq $first ) {
            # редиректа не было, не фиксируем
            $last = undef;
        }

        my $response_params = {};
        for my $kv (@others) {
            my ($k,$v) = split /=/, $kv, 2;
            $response_params->{$k} = $v;
        }
        $httpcode = $response_params->{httpcode} if $response_params->{httpcode};
        $self->throttle($response_params);

        #если урл всего один, не проверяем, соответствует ли он тому, что в ответе Зоры
        #Зора может отдать урл после редиректа, который не будет совпадать с исходным.
        #todo придумать что-нибудь для множества урлов

        if (scalar(keys %$url_hash) == 1) {
            ($first) = (keys %$url_hash);
        }
        my $download_error = $response_params->{errorclass};
        # при ошибке скачивания продолжаем работать, потому что сначала все равно надо достать из файла ответ, чтобы дескриптор встал куда надо
        if ( $download_error eq '(null)' ) {
            $download_error = '';
        }
        if ( $httpcode >= 1000 ) {
            # внутренняя ошибка Зоры
            $download_error = $httpcode;
        }
        #$self->log("Process downloaded: first: $first   other: ".($other//""));
        if ( $first && exists($url_hash->{$first})) {

            # httpcode
            $result->{$first}{httpcode} = $httpcode;
            $result->{$first}{location} = $last if $last;
            if ( $download_error ) {
                $result->{$first}{download_error} = $download_error;
            }
            my $size = <fF>; chomp($size);
            if ( $size =~ /\d/ && int($size) > 0 ) {
                my $tmp_file = get_tempfile('multi_get_extras', UNLINK => 1);
                open my $tmp_fh, '>', $tmp_file or die $!;
                binmode $tmp_fh;
                my $tmp_bytes_read = 0;
                my $block_size = 100000;
                while ( $tmp_bytes_read + $block_size < $size ) {
                    my $buffer;
                    my $bytes_read = read(fF, $buffer, $block_size);
                    die $! if !defined $bytes_read;
                    last if !$bytes_read;
                    print $tmp_fh $buffer;
                    $tmp_bytes_read += $bytes_read;
                }
                if ($tmp_bytes_read < $size) {
                    my $buffer;
                    my $bytes_read = read(fF, $buffer, $size - $tmp_bytes_read);
                    die $! if !defined $bytes_read;
                    print $tmp_fh $buffer;
                }
                close $tmp_fh;

                my $decoded_content;
                my $content_is_text = 0;
                my $result_file = get_tempfile('multi_get_extras', UNLINK => 1);
                if ( content_is_text($response_params->{mime}) ) { #текст, работаем с кодировками
                    $content_is_text = 1;
                    #сначала попробуем кодировку, которая указана в ответе Зоры
                    my $response_charset = $response_params->{encoding};
                    my @charset_candidates = $self->proj->detect_charset->detect_file_charset_candidates($tmp_file, $response_params->{mime});
                    if ( $response_charset && ( lc($response_charset) ne 'iso-8859-1' ) && ( lc($response_charset) ne 'windows-1252' ) && ( lc($response_charset) ne 'windows-1251' ) ) {
                        # iso-8859-1 and windows-1252 are common detecting errors.
                        # windows-1251 - ненадежно в Zora
                        # остальное берем
                        unshift(@charset_candidates, $response_charset);
                    }
                    $self->proj->detect_charset->file_charsets2utf8($tmp_file, $result_file, \@charset_candidates);
                }
                else { #бинарник, не трогаем содержимое вообще
                    File::Copy::copy($tmp_file, $result_file);
                }
                unlink $tmp_file;
                if (-z $result_file) {
                    $self->log("ERROR: bad content while zora downloading url:$first!");
                    $result->{$first}{download_error} = "Failed to encode to UTF-8";
                    next;
                }
                $result->{$first}{content_is_text} = $content_is_text;
                if ($url_params->{$first}{result_file}) {
                    File::Copy::move($result_file, $url_params->{$first}{result_file});
                }
                else {
                    my $mode;
                    if ( content_is_text($response_params->{mime}) ) { #текст, используем строгое декодирование из utf-8
                        $mode = '<:encoding(utf-8)';
                    }
                    else { #бинарные данные, грузим в сыром виде
                        $mode = '<:raw';
                    }

                    #File::Slurp не подходит здесь, так как он не дает включить строгий режим utf-8 из-за бага (https://rt.cpan.org/Public/Bug/Display.html?id=83126)
                    #поэтому загружаем через open
                    open my $result_fh, $mode, $result_file or die $!;
                    eval {
                        #если будет ошибка чтения из-за декодирования в текстовом режиме, мы воспримем это как битые данные и передадим дальше информацию о неудачном скачивании
                        $decoded_content = do { local $/; <$result_fh> }; # надо прочитать все сразу, поэтому ставим локально в undef значение перлового сепаратора
                    };
                    close $result_fh;
                    # файл уже не нужен
                    unlink $result_file;

                    if (!defined $decoded_content) {
                        $self->log("ERROR: bad content while zora downloading url:$first!");
                        $result->{$first}{download_error} = " Failed to load encoded file";
                        next;
                    }

                    # content
                    $result->{$first}{content} = $decoded_content;
                    $total_size += $size;
                    next if $params->{light};

                    # title
                    ( $result->{$first}{title} ) = ( $decoded_content =~ /.*?<title(?:\s(?:(?:[^>"]*)|(?:".*?"))*)*>(.*?)<\/title>/ims );

                    if ( !defined($result->{$first}{title}) ) { $result->{$first}{title} = ""; }
                }
            }
        }
    }
    close fF;
    $self->log("uploaded " . sprintf("%.3f", $total_size / 1024 / 1024 ) . " MB");
    unlink $temp_file;
    unlink $temp_file2;
    return $result;
}

1;

