package DataSource::Filter::Filter;

use std;

use base qw(ObjLib::Obj);
use Data::Dumper;

use DataSource::Filter::Filter_sum;

use overload '+' => \&my_plus,
             '*' => \&my_star;

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(
    'f',        #Данные фильтрации
    'pref',     #Имя таблицы для полей, если нужен
    'concat_type', #Способ объединения условий
);


########################################################
#Методы
########################################################

#Экранирует поле
sub FieldScreening {
    my ($self, $field) = @_;
    return $field ne '*' ? '`'.$field.'`' : $field;
}


#Экранирует поля в массиве 
sub FieldsScreening {
    my ($self, @fields) = @_;
    return map { $self->FieldScreening( $_ ) } @fields;
}

#Фильтр в формате
# {
#     'ID'  => '2323',
#     'act' => '2',
# }
# либо
# [
#     [ 'ID'                 '2323'   ],
#     [ 'title', '!=',       '2323'   ],
#     [ 'type'               ['1', '2', '3' ] ],
#     [ 'act',   'not in',   ['1', '2', '3' ] ],
#     [ 'ID',    '           2323' ],
# ]
# либо строкой
# q{ ID = '2323' and act not in ('1', '2', '3' ) }
# либо объектом DataSource::Filter::Filter

sub filter2str {
    my $self = shift;

    my $filter = $self->f;
    my $_pref  = $self->pref || shift;

    my $cnct = $self->concat_type || 'AND';
    $cnct = " $cnct ";

    my $where_d = '';
    my @arr_k = ();
    my @arr_v = ();
    my $pref = $_pref ? $_pref.'.' : '';

    if( ref($filter) eq 'HASH' ){
        my $fields = [ keys %$filter ];
#        $where_d = join( ', ', map { $_.'=?' } @$fields );
#        @arr_v   = @{$filter}{@$fields};
        for my $sk ( keys %$filter ){
            my ($k,$v) = ($sk , $filter->{$sk});
            my $notv = $sk =~ /\snot\s*$/i;
            $k =~ s/\snot\s*$//i if $notv;
            $k = $pref.$self->FieldScreening($k) if $sk !~ m{[(*/+-]};
            $k .= ' NOT ' if $notv;
            my $c = '';
            if( $sk =~ /(.+)\s+(LIKE|REGEXP|\<=?|\>=?|\!=|\<\>)/){ #Позволяем указывать LIKE и регулярки через хэш
                push( @arr_k, " $sk ? " );
                push( @arr_v, $v );
            }elsif( $sk =~ /(.+)\s+NULL\s*$/){ #Позволяем указывать LIKE и регулярки через хэш
                push( @arr_k, " $sk " );
            }elsif( ref($v) eq 'ARRAY' ){ #Если нужно проверить вхождение в массив
                $c = 'in';
                my @arr = grep { defined($_) } @$v; #Проверяем, так как наличие undef в списке in приводит к пустому результату
                if(@arr){
                    push( @arr_k, ($k.' '.$c.' ('.('?, ' x  (@arr-1)).'?) ' ) );
                    push( @arr_v, @arr );
                }else{
                    return ('1=1',[]) if $notv;
                    return ('1=2',[]); #Так как в любом случае ничего не вернёт
                }
            }elsif( ref($v) eq 'HASH' ){ #Если нужно наложить рекурсивное условие
                my $ff = $self->create_or_filter( $v );
                my ($wh, $warr) = $ff->filter2str;
                $wh = "( $wh )" if $wh;
                push( @arr_k, $wh ); 
                push( @arr_v, @$warr );
            }else{
                $c = '=';
                push( @arr_k, ($k.$c.'?') );
                push( @arr_v, $v );
            }
        }
        $where_d = join( $cnct, @arr_k );
    }elsif( ref($filter) eq 'ARRAY' ){
        #Фильтр задан массивом
        for( @$filter ){
            my ($k,$c,$v);
            if( @$_ == 2 ){
                ($k,$c,$v) = ($_->[0], undef, $_->[1] );
                return ('1=2',[]) unless defined($_->[0]); #Так как в любом случае ничего не вернёт
                return ('1=2',[]) unless defined($_->[1]); #Так как в любом случае ничего не вернёт
            }elsif( @$_ == 3 ){
                ($k,$c,$v) = @$_;
            }elsif( @$_ == 1 ){
                ($k,$c,$v) = ($_->[0], undef, undef);
            }else{
                return ('1=2',[]); #Так как в любом случае ничего не вернёт
            }
            $k = $pref.$self->FieldScreening($k) if @$_ != 1 && $k !~ m{[(*/+-]};
            if( ref($v) eq 'ARRAY' ){ #Если нужно проверить вхождение в массив
                $c = $c || 'in';
                my @arr = grep { defined($_) } @$v; #Проверяем, так как наличие undef в списке in приводит к пустому результату
                if(@arr){
                    push( @arr_k, ($k.' '.$c.' ('.('?, ' x  (@arr-1)).'?) ' ) );
                    push( @arr_v, @arr );
                }else{
                    return ('1=2',[]); #Так как в любом случае ничего не вернёт
                }
            }elsif( $k && ! defined($v) ){ #Задана сама SQL строка
                push( @arr_k, $k);
            }elsif(defined($c) && $c =~ /^\s*(<>|=)\s*(ANY|ALL)\s*$/i) {
                push( @arr_k, ($k.$c." ($v)") );
            }else{
                $c = $c || '=';
                push( @arr_k, ($k.$c.'?') );
                push( @arr_v, $v );
            }
        }
        
        $where_d = join( $cnct, @arr_k );
    }elsif( ref($filter) ){ #Объект, предположительно фильтрации
        return $filter->filter2str($_pref);
    }elsif($filter){
        #Фильтр задан строкой
        $where_d = $filter;
    }else{
        #Фильтр не задан
        $where_d = $filter;
    }

    return ($where_d, \@arr_v);
}

sub my_star {
    my $f = DataSource::Filter::Filter_sum->new;
    $f->add_f([@$_]) for @_;
    return $f;
}

sub my_plus {
    my $f = DataSource::Filter::Filter_sum->new( { 'c' => 'OR' } );
    $f->add_f([@$_]) for @_;
    return $f;
}

sub create_or_filter {
    my ($self, $f) = @_;
    my $ff = DataSource::Filter::Filter->new({ f => $f, pref => $self->pref, concat_type => 'OR' });
#print Dumper([$f]);
    #$ff->concat_type('OR');
    return $ff;

}


1;
