package DataSource::Filter::Filter_sum;

#Объединение фильтров

use std;

use DataSource::Filter::Filter;

use base qw(ObjLib::Obj);

#use overload '+' => \&my_plus,
#             '*' => \&my_star;

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(
    'f_array',     #Список фильтров
    'c',       #Тип объединения, по умолчанию 'AND'
);

########################################################
# Инициализация
########################################################

sub init {
    my $self = shift;
    $self->c('AND') unless $self->c;
    $self->f_array([]) unless $self->f_array;
}


########################################################
#Методы
########################################################

sub add_f {
    my ($self, $f, $pref) = @_;
    push( @{$self->f_array}, DataSource::Filter::Filter->new({ f => $f, pref => $pref }) );
}

#Объединяем разные фильтры
sub filter2str {
    my ($self, $pref) = @_;
    
    undef $pref if ref($pref); # фильтр передали как аргумент. не надо так делать: $f->filter2str($f)
    
    my ($where, $arr) = ('',[]);
    my $brackets = @{$self->f_array} > 1;
    for my $cf (@{$self->f_array}){
        my ($where_e, $arr_e) = $cf->filter2str($pref);
        if($where_e){
            $where .= ' '.$self->c.' ' if $where;
            $where .= ' ( ' if $brackets;
            $where .= ' '.$where_e.' ';
            $where .= ' ) ' if $brackets;
            push(@$arr, @$arr_e);
        }
    }

    return ($where, $arr);
}

sub my_star {
    my $f = DataSource::Filter::Filter_sum->new;
    $f->add_f([$_]) for @_;
    return $f;
}

sub my_plus {
    my $f = DataSource::Filter::Filter_sum->new( { 'c' => 'OR' } );
    $f->add_f([$_]) for @_;
    return $f;
}


1;