package DataSource::deferreddbi;

use std;

use DBI;

use base qw(ObjLib::ProjPart);

use vars qw($AUTOLOAD);

use DataSource::Elem;
use File::Slurp qw(read_file);

sub init {
    my $self = shift;
    $self->lasttime(0);
    $self->dbh(undef);
}

__PACKAGE__->mk_accessors(
    'dbh',
    'db_opt',
    'lasttime',
);

sub get_connect_params {
    my $self = shift;
    my $host_name = shift // $self->db_opt->{hosts}->[0];
    die "get_connect_params failed, hostname not selected" unless $host_name;
    
    if (!$self->db_opt->{password} and $self->db_opt->{password_path}) {
        die "file with password not found: ".$self->db_opt->{password_path} if !-e $self->db_opt->{password_path};
        $self->db_opt->{password} = read_file($self->db_opt->{password_path});
        chomp $self->db_opt->{password};
    }
    
    my $data_source = "DBI:mysql:database=".$self->db_opt->{database}.";host=$host_name;port=".$self->db_opt->{port};
    my @connection_args = ($data_source,);
    for my $k (qw (user password db_attr)) {
        push(@connection_args, $self->db_opt->{$k});
    }
    return \@connection_args;
}

sub _tmp_dbtable {
    my ($self) = @_;
    $self->{'_tmp_dbtable'} = DataSource::Elem->new({ proj => $self->proj, dbh => $self }) unless $self->{'_tmp_dbtable'};
    return $self->{'_tmp_dbtable'};
}

sub List_SQL {
    my ($self, $SQL, $arr) = @_;
    return $self->_tmp_dbtable->List_SQL($SQL, $arr);
}

sub Do_SQL {
    my ($self, $SQL, $arr) = @_;
    $self->_tmp_dbtable->Do_SQL($SQL, $arr);
}

sub reconnect {
    my $self = shift;
    $self->dbh->disconnect if $self->dbh;
    $self->do_connect;
}

sub do_connect {
    my $self = shift;
    my $tries = shift // 10;
    
    my $hosts = $self->db_opt->{hosts};
    
    for my $try (1 .. $tries) {
        for my $host (@$hosts) {
            my $connect_params = $self->get_connect_params($host);
            
            my $dbh = undef;
            eval {
                $dbh = DBI->connect(@$connect_params);
            };

            if ($dbh) {
                # соединились
                # SET CHARACTER SET -- ЛОМАЕТ вставку бинарных (напр., гзипованных) данных, нельзя выставлять
                $dbh->do('SET NAMES UTF8');
                $dbh->{mysql_enable_utf8} = 1;
                $dbh->{mysql_auto_reconnect} = 1;
                $self->dbh($dbh);
                my $is_read_only = $self->List_SQL('SELECT @@global.read_only is_read_only')->[0]->{is_read_only};
                next if $is_read_only == 1;
                return;
            }
        }
        print "DBI connect fail sleep 5\n";
        sleep 5;
    }
    # не получилось
    $self->dbh(undef);
    die "Can't connect to mysql: $DBI::errstr; master not found.\n";
}

sub AUTOLOAD {
    my $self = shift;
    my $attr = $AUTOLOAD;
    $attr =~ s/.*:://;
    return unless $attr =~ /[^A-Z]/;  # skip DESTROY and all-cap methods
    unless($self->dbh){
        $self->do_connect;
    }
    my $tm = time;
    if($tm - $self->lasttime > 300){
        $self->lasttime($tm);
        eval {
            $self->dbh->do('SET NAMES UTF8');
        };
        if($@ || $self->dbh->err) {
            my $err = $self->dbh->err // $DBI::err;
            my $errstr = $self->dbh->errstr // $DBH::errstr;
            $self->log("set names utf8 failed: $err $errstr");
            $self->log($self->proj->stack_trace);
            $self->log("params: " . join(",", @_));
            $self->reconnect;
            $self->dbh->do('SET NAMES UTF8');
        }
        $self->dbh->{'mysql_enable_utf8'} = 1;
    }
    my $params = \@_;
    my $result;
    eval {
        $result = $self->dbh->$attr(@_);
    };
    if ($@) {
        my $strace = $self->proj->stack_trace('  DBH ERROR   ').join('', map {"  DBH SQL     $_\n"} @$params);
        my $msg = sprintf "dbh error %d: [%s]; SQL: %s", $DBI::err, $DBI::errstr, join(';', @_);
        die($msg."\n".$strace);
    }
    return $result;
};

1;
