package IronProject;

use strict;
use utf8;
use open ':utf8';

use base qw(BaseProject);

#
# Часть Project-а, нужная для работы полноценных перловых скриптов на железе,
# не внутри yt-джобов
#

use DataSource::deferreddbi;                    #Bложенное соединение
use DataSource::Elem;

use BM::Banners::BannerFactoryDB;
use BM::Banners::BannerFactoryYT;

use BM::SwitchmanClient;
use BM::SandboxClient;
use BM::BMClient::RandomBannersClient;
use BM::BMClient::HttpServerControl;
use BM::BMClient::DistrBannersBender;
use BM::BMClient::BenderClient;

use BM::YT::Client;
use BM::YT::YTTable;

use BM::BMClient::ServerCommands;

use BM::Monitor::Utils;



__PACKAGE__->mk_accessors((
    'random_banners_client',
    'dbh',
    'monitoring_dbh',
    'catalogia_media_dbh',
    'catalogia_media_repl_dbh',
    'bannerland_dbh',
    'db_uploader',
    #@returns BM::Banners::BannerFactoryDB
    'banner_factory',
    #@returns BM::Banners::BannerFactoryDB
    'bf',
    'bf_slow',

    'banners_bender',
    'distr_banners_bender',
    'bender_client',
    'yt_client',

    'sandbox_client',

    'http_server_control',
    'server_command',
));

sub get_proj_dbh {
    my ($self, $optname) = @_;
    return $self->connect($self->options->{$optname}, $self->options->{dbAttr});
}

sub init {
    my $self = shift;
    return if $self->get_calls_count_and_inc();

    $self->SUPER::init;

    my $options = $self->options;

    # клиент random_banners
    $self->{random_banners_client} = BM::BMClient::RandomBannersClient->new({
        proj => $self,
    });

    # DB-uploader - загрузка файлов в базу
    -d $_ || mkdir $_ for @{$options->{db_uploader_params}}{qw(work_dir temp_dir)};


    $self->{dbhlist} = {
        monitoring_dbh      => $self->monitoring_dbh(      $self->get_proj_dbh('monitoring_db_inf') ),
        catalogia_media_dbh             => $self->catalogia_media_dbh(             $self->get_proj_dbh('catalogia_media_db_inf') ),
        # синонимы:
        catalogia_media_repl_dbh        => $self->catalogia_media_repl_dbh(        $self->get_proj_dbh('catalogia_media_db_inf') )

        # banners_dbh - см. ниже
    } unless $self->{dbhlist};
    if ((defined $self->{main_dbh}) && ($self->{dbhlist}{$self->{main_dbh}})) {
        $self->dbh( $self->{dbhlist}{$self->{main_dbh}} );
    }

    $self->{dbhlist}->{bannerland_dbh} = $self->bannerland_dbh($self->get_proj_dbh('bannerland_db_inf'));

    # Фабрика баннеров
    # TODO выбор в зависимости от роли поместить в конфиги (?)
    my $banners_dbh = $self->catalogia_media_repl_dbh;
    $self->{dbhlist}{banners_dbh} //= $banners_dbh;

    my $bf_init = {
        proj => $self,
        banners_dbh => $banners_dbh,
    };

    $self->banner_factory(BM::Banners::BannerFactoryDB->new({ %$bf_init }));
    $self->bf($self->banner_factory);

    $self->bf_slow(BM::Banners::BannerFactoryYT->new({ %$bf_init }));

    $self->{sandbox_client} = BM::SandboxClient->new({
        proj    => $self,
        %{$options->{'sandbox_params'}},
    });
    (-d $_ || mkdir $_) for (
        $self->sandbox_client->temp_dir,
        $self->sandbox_client->work_dir,
    );

    # клиент bender
    $self->{bender_client} = BM::BMClient::BenderClient->new({
        proj => $self,
        %{$options->{bender_params}}
    });
    (-d $_ || mkdir $_)  for ($self->bender_client->temp_dir, $self->bender_client->work_dir);
    $self->{distr_banners_bender} = BM::BMClient::DistrBannersBender->new({
        proj => $self,
        %{$options->{bender_params}},
        %{$options->{DistrBannersBender_params}},
    });
    $self->{banners_bender} = $self->{distr_banners_bender};

    # http-сервер
    $self->{http_server_control} = BM::BMClient::HttpServerControl->new({
        proj => $self,
        %{$options->{BaseHttpServer_params}},
    });

    $self->{server_command} = BM::BMClient::ServerCommands->new({ proj => $self });

    $self->yt_client(BM::YT::Client->new({
        proj => $self,
        %{ $options->{yt_client_params} },
    }));

}

#
# MAIL
#

sub mails {
    my ($self) = @_;
    return $self->{'mails'} if $self->{'mails'};

    require Mails;
    $self->{'mails'} = Mails->new({
        mail_lists => $self->options->{mail_lists},
        debug_mode => $self->options->{mails_debug_mode},
    });

    return $self->{'mails'};
}

sub SendMail {
    my ($self, $opts) = @_;
    return $self->mails->SendMail($opts);
}


# Получить email пользователя по его логину
# Если пользователь есть в таблице, но не указан его е-мэйл, то возвращается "Логин@yandex.ru"
sub login2email {
    my ($self, $login) = @_;
    return if not $login;
    my $tbl = $self->dbtable('Users', '', 'catalogia_media_dbh')  // do {
        $self->log("ERROR: Could not get dbtable('Users', '', 'catalogia_media_dbh')");
        return;
    };
    my $list = $tbl->List({Login => $login}) || return;
    return if not @$list;
    my $email = $list->[0]{EMail} || $login.'@yandex.ru';
    return $email;
}

# Посылает е-мэйл пользователю
# На входе:
#   Параметры для SendMail
#   Дополнительные параметры:
#       yandex_login        Логин пользователя на "yandex"
#       yandex_team_login   Логин пользователя на "yandex-team"
#       default_to          Адрес, на который будет отправлен е-мэйл, если не удалось определить адрес пользователя по логину
#       add_descr           1/0  Добавить текст "это письмо было создано автоматически..."
#       responsible_email   Адрес, куда пользователь может обращаться с вопросами
sub send_mail_to_user {
    my ($self, $mail, %prm) = @_;
    my $mail_opts = ref($mail) eq 'HASH' ? $mail : {};
    my $yandex_login = $prm{yandex_login} // '';
    my $yandex_team_login = $prm{yandex_team_login} // '';

    my $email_to = ($yandex_team_login ? $yandex_team_login . "\@yandex-team.ru" : "")
        || ($yandex_login ? $self->login2email($yandex_login) : "")
        || $prm{default_to}
        || $mail_opts->{to};

    if (not $email_to) {
        $self->log("ERROR: Void email");
        return;
    }

    my $body = join("",
        ($mail_opts->{body} // ""),
        ($prm{add_descr} ? ( "\n\n"
                . "Это письмо сформировано автоматически. Пожалуйста, не отвечайте на него.\n"
                . "Если у Вас возникли вопросы о полученном файле, Вы можете писать на адрес "
                .   ($prm{responsible_email} // 'emurav@yandex-team.ru') . "\n"
            ) : ""
        ),
    );

    $self->SendMail({
        from => 'no_reply@yandex-team.ru',
        to => $email_to,
        subject => "Ordeded data",
        %$mail_opts,
        body => $body,
    });
}

#
# MySQL
#

sub dbtable {
    my ($self, $db_table, $id_field, $dbhname) = @_;
    return DataSource::Elem->new({
            %{$self->dsih($dbhname)},
            db_table => $db_table,
            id_field => $id_field,
            dbhname => $dbhname,
        });
}

sub dbhlist {
    my ($self) = @_;
    return $self->{'dbhlist'};
}

sub dsih {
    my ($self, $dbhname) = @_;

    if( $dbhname ){
        return {
            dbh       => $self->dbhlist->{$dbhname},
            dbh_read  => $self->dbhlist->{$dbhname},
            proj      => $self,
            dbhname   => $dbhname,
        };
    }

    return {
        dbh       => $self->dbh,
        dbh_read  => $self->dbh,
        proj      => $self,
        dbhname   => $dbhname,
    };
}

sub connect {
    my ($self, $db, $db_attr) = @_;
    $db->{db_attr} //= $self->{options}->{'dbAttr'};
    return DataSource::deferreddbi->new({proj => $self, db_opt => $db});
}

sub disconnect {
    my ($self, $dbh) = @_;
    return $dbh->disconnect;
}

sub List_SQL {
    my ($self, $SQL, $arr) = @_;
    return $self->dbh->List_SQL($SQL, $arr);
}

sub Do_SQL {
    my ($self, $SQL, $arr) = @_;
    $self->dbh->Do_SQL($SQL, $arr);
}

# Меняем настройки, чтобы можно было передавать в базу большие запросы
sub big_sql_data {
    my ($self) = @_;

    return unless $self->dbh;

    my $max_allowed_packet = 300000000;
    # Меняем значение max_allowed_packet, если текущее значение меньше необходимого
    my $list = $self->List_SQL("SHOW GLOBAL VARIABLES LIKE 'max_allowed_packet'");
    unless (@$list && $list->[0]{Value} >= $max_allowed_packet) {
        eval { $self->Do_SQL("SET GLOBAL max_allowed_packet=$max_allowed_packet"); };
    }
}

#
# Misc
#

#@returns BM::Banners::LBannerBM
sub text2banner { shift->bf->text2banner(@_) }
#@returns BM::Banners::LBannerBM
sub bid2banner  { shift->bf->get_banner_by_id(@_) }
#@returns BM::Banners::LBannerBM
sub bsid2banner  { shift->bf->get_banner_by_bsid(@_) }

sub sw_client {
    my ($self) = @_;
    unless ($self->{sw_client}) {
        $self->{sw_client} = BM::SwitchmanClient->new({
            proj => $self,
            %{ $self->options->{switchman_client_params} },
        });
    }

    return $self->{sw_client};
}

sub get_yt_client {
    my $self = shift;
    return BM::YT::Client->new({
        proj => $self,
        @_,
    });
}

sub graphite_client {
    my $self = shift;
    return BM::Monitor::Utils::graphite_client();
}

1;
