package ObjLib::Attr;

use Data::Dumper;

BEGIN {
    $qtestslist = {};
    $qtestsrules = {};
    $atestslist = {};
}

sub _qtests_list { return $qtestslist; }
sub _qtests_rules { return $qtestsrules; }

sub _atests_list { return $atestslist; }
sub _dtests_list { return $dtestslist; }

sub QTEST : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        #print Dumper([$package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum]);
        #my $txtlist = $data->[0] || '';
        #my @slist = split /\s+/, $txtlist; #Список ролей, для которых нужно проверять доступность сервисов
        
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;

        #$qtestslist->{$_}{$name} = $referent for @slist;
        $qtestslist->{$name} = $referent;
        #print Dumper($qtestslist);
    }
}

sub QTESTRULES : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {  
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;

        #$qtestslist->{$_}{$name} = $referent for @slist;
        my $tests = $referent->(); #Получаем хэш списков проверочных вызовов
        for my $hrole ( keys %$tests ){
            $qtestsrules->{$hrole} ||= []; #Создаём массив правил для хоста
            push( @{$qtestsrules->{$_}}, @{$tests->{$hrole}}) for grep {$_} split /\s+|,/, $hrole;
        }
    }
}

sub ATEST : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        $name = "$package->$name";

        $atestslist->{$name} = $referent;
        #print Dumper($atestslist);
    }
}

sub DTEST : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        $name = "$package->$name";

        $dtestslist->{$name} = $referent;
        #print Dumper($dtestslist);
    }
}

1;
