package ObjLib::FileIter;

use utf8;
use open ':utf8';

use base qw(ObjLib::Obj);

no warnings 'utf8'; # из-за варнингов ловим segfault в bmapi, глушим варнинги до решения DYNSMART-863

# параметры:
#   filename        => subj
#   tskv_key_field  => поле для вырезания ключа из строки в tskv-формате
sub init {
    my ($self) = @_;
    open my $fh, '<', $self->{filename}
        or die("Cant open file '".$self->{filename}."' - $@");
    $self->{fh} = $fh; 
}

sub _get_key {
    my $self = shift;
    my $line = shift;
    if (defined $self->{tskv_key_field}) {
        for my $kv (split /\t/, $line) {
            my ($k, $v) = split /=/, $kv, 2;
            return $v if $k eq $self->{tskv_key_field};
        }
        return;
    } else {
        die "Don't know how to get key!";
    }
}

# получить очередную пачку строк (без newline)
sub get_pack {
    my ($self, $size) = @_;
    $size ||= 1000;
    my $cc = 0;
    my $fh = $self->{fh};
    my @res = ();
    while(<$fh>){
        chomp;
        push(@res, $_); 
        $cc++;
        unless($cc < $size){
            last;
        }
    }
    unless( @res ){
        close($fh);
        return undef;
    }
    return \@res;
}

# в отсортированном файле находит записи с данным ключом
# соотв., нужно вызывать для отсортированных ключей, до получения undef
sub get_lines_by_key {
    my $self = shift;
    my $key = shift;

    if (defined $self->{prev_key} and $self->{prev_key} eq $key) {
        return $self->{prev_lines};
    }

    my $fh = $self->{fh};
    return if !$fh;

    my @res;
    while (1) {
        # если до этого нашли строку с бОльшим ключом, то нужно сейчас её обработать
        my $line;
        if (defined $self->{last_line}) {
            $line = delete $self->{last_line};
        } elsif (eof($fh)) {
            # необработанных строк не осталось
            close $fh;
            delete $self->{fh};
            last;
        } else {
            $line = <$fh>;
            chomp $line;
        }
        my $curr_key = $self->_get_key($line);
        if ($curr_key lt $key) {
            next;
        } elsif ($curr_key gt $key) {
            $self->{last_line} = $line;
            last;
        } else {
            push @res, $line;
        }
    }
    $self->{prev_key} = $key;
    $self->{prev_lines} = \@res;
    return \@res;
}

sub DESTROY {
    my $self = shift;
    close $self->{fh} if defined $self->{fh};
}

1;
