package ObjLib::FileLogger;
use strict;

=pod
    Альтернативный логгер :-)
    По мотивам Yandex::Log из Директа

=head1 SYNOPSIS

  my $logger = ObjLib::FileLogger->new({log_file => 'balance_update.log'});
  $logger->info('message 1');
  $logger->info('message 2');

=cut

use utf8;
use open ':utf8';

use IO::Handle;

use base qw(ObjLib::BaseLogger);

sub init {
    my $self = shift;
    $self->SUPER::init;

    if (defined $self->{log_file}) {
        open my $fh, ">>", $self->{log_file}
            or die "Can't open log_file `$self->{log_file}': $!";
        $fh->autoflush(1);
        $self->{fh} = $fh;
    } elsif ($self->{log_fh}) {
        $self->{is_external} = 1;  # do not close
        $self->{fh} = $self->{log_fh};
    } else {
        die "Define log_file or log_fh for FileLogger!\n";
    }
    
    $self->{preprocess}{log_msg_fmt} //= 1;
}

sub out {
    my ($self, $text) = @_;
    $self->{fh}->print($text . "\n");
}

sub reopen {
    my ($self, $filename) = @_;
    if ($self->{is_external}) {
        die "Can't reopen external fh!\n";
    }
    $self->{fh}->close();
    open my $fh, ">>", $filename
        or die "Can't reopen log_file `$filename': $!";
    $fh->autoflush(1);
    $self->{fh} = $fh;
}

sub DESTROY {
    my $self = shift;
    unless ($self->{is_external}) {
        $self->{fh}->close();
    }
}

1;
