package ObjLib::Obj;

use std;

use Data::Dumper;

use JSON::XS;

use Class::Accessor::Fast;
use base qw(Class::Accessor::Fast); #Класс, позволяющие определять accessors
use Digest::MD5 qw(md5_hex);
use File::Path qw(make_path);
use Time::HiRes;


use utf8;
use open ':utf8';

use Attribute::Handlers;

our $cache_stats = {};

sub new{
    my $proto  = shift;
    my $class  = ref($proto) || $proto; #Класс, к которому приводим
    my $self = shift() || {};
    my %par  = @_;
    bless($self,$class);
    unless ($par{no_init}) {
        $self->init if $self->can('init');#Если есть функция инициализации, инициализируем
        $self->after_init if $self->can('after_init');
    }
    return $self;
}

#Без проверки init - сокращает время создания новых объектов
sub new_lite{
    my $proto  = shift;
    my $class  = ref($proto) || $proto; #Класс, к которому приводим
    my $self = shift() || {};
    bless($self,$class);
    return $self;
}

sub log {
    my ($self, $error) = @_;
    print STDERR $error."\n";
};


our $dtdmp_fixed = 0;

sub _dtdmp_fix {
    print STDERR "_dtdmp_fix\n";
    $Data::Dumper::Useqq = 1;
    {
        no warnings 'redefine';
        sub Data::Dumper::qqoute {
            my $s = shift;
            return "'$s'";
        }
    }
    $dtdmp_fixed = 1;
    $Data::Dumper::Terse = 1;
    $Data::Dumper::Indent = 1;
#    $Data::Dumper::Toaster = 'dumper_text';
    $Data::Dumper::Freezer = 'dumper_text';
}

sub _dtdmp_fix_lite {
    print STDERR "_dtdmp_fix_lite\n";
    $Data::Dumper::Useqq = 1;
    {
        no warnings 'redefine';
        sub Data::Dumper::qqoute {
            my $s = shift;
            return "'$s'";
        }
    }
    $dtdmp_fixed = 2;
    $Data::Dumper::Terse = 1;
    $Data::Dumper::Indent = 1;
#    $Data::Dumper::Toaster = 'dumper_text';
    $Data::Dumper::Freezer = 'dumper_text_lite';
}

sub dump {
    my $self = shift;
    _dtdmp_fix unless $dtdmp_fixed == 1;
    return Dumper(@_);
}

sub dump_lite {
    my $self = shift;
    _dtdmp_fix_lite unless $dtdmp_fixed == 2;
    return Dumper(@_);
}

sub ___error {
    my ($self, $error) = @_;
    
    if (defined $error) {
        $self->{'__ERROR__'} = $error;
        return;
    };
    
    return $self->{'__ERROR__'};
};


sub sys_error {
    my $self = shift;
    my $text = shift;
    my ($package, $filename, $line, $subroutine, $hasargs, $wantarray) = caller(0);
    print STDERR '['.localtime().'] '."[error] $package, $filename, $line : $text\n";
    my $i = 0;
    while(++$i){
        my ($package, $filename, $line, $subroutine,$hasargs, $wantarray) = caller($i);
        last if $subroutine eq 'partner::handler';
        last if $subroutine eq '';
#        print STDERR "    -- $package, $filename, $line : $subroutine\n";
        print STDERR "    -- $package, $line - $subroutine\n";
    }
}

sub ___sys_error {
    my ($self, $text, $exit) = @_;
#    SysError($self, $text, $exit);
}

sub _memory_id {
    my $self = shift;
    return scalar(\$self);    
}

sub _stack_trace {
    my ($self) = @_;

    my $i = 1;
    my @st = ();
    while(++$i) {
        my ($package, $filename, $line, $subroutine, $hasargs,
            $wantarray, $evaltext, $is_require, $hints, $bitmask) = caller($i);

        last if !defined($package);
        
        push(@st, {
            package     => $package,
            filename    => $filename,
            line        => $line,
            subroutine  => $subroutine,
        });
    };
    return \@st;
};

sub stack_trace {
    my ($self, $pref) = @_;
    $pref = '    ' unless $pref;
    my $arr = $self->_stack_trace;
    #my $text = join "", map { $pref.$_->{package}." ".$_->{line}." => ".$_->{subroutine}."\n" } reverse @$arr;
    my $text = join "", map { $pref.$_->{subroutine}." <= ".$_->{package}." ".$_->{line}."\n" } reverse @$arr;
    return $text;
}

# for class methods
sub STATIC :ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    no warnings 'redefine';
    *$symbol = sub {
        my $self = shift;
        my $class = ref($self) || $self;
        return $referent->($class, @_);
    };
}

#Очистка кэшей
sub _delete_cached_inf {
    my ($self) = @_;
    delete($self->{$_}) for grep {/^_cached_/} keys %$self;
}
sub _set_cache {
    my $self = shift;
    my $method = shift;
    my $value = shift;
    
    $self->{"_cached_$method"} = [$value];
}
sub _is_cached {
    my $self = shift;
    my $method = shift;
    return (defined $self->{"_cached_$method"} ? 1 : 0);
}


sub CACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = $$symbol;
        $tt =~ s/.+:://;
        my $t = "_cached_${tt}";
        no warnings 'redefine';
        *$symbol = sub {
            my $self = $_[0];
            my $h = $self->{$t};
            if (!defined $h) {
                $self->{$t} = $h = [$referent->($self)];
            }
            return wantarray ? @$h : $h->[0];
        };
        if ($ENV{BM_DEBUG_OBJLIB_CACHE}) {
            *$symbol = sub {
                my $self = $_[0];
                my $h = $self->{$t};
                my $sth = ($cache_stats->{$$symbol} //= {});
                if (!defined $h) {
                    my $start = Time::HiRes::time();
                    $self->{$t} = $h = [$referent->($self)];
                    my $call_time = Time::HiRes::time() - $start;
                    if ($self->{"_called_bits"}{$tt}) {
                        # значение должно было быть закэшировано, но пришлось вычислять заново
                        $sth->{waste_call_time} += $call_time;
                        $sth->{waste_call_count}++;
                    } else {
                        $sth->{first_call_time} += $call_time;
                        $sth->{first_call_count}++;
                    }
                    $self->{"_called_bits"}{$tt} = 1;
                } else {
                    $sth->{hit_count}++;
                }
                return wantarray ? @$h : $h->[0];
            };
        }
    }
}

#Более быстрый вариант кэша, так как не предполагает возврата массива
sub SCACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = $$symbol;
        $tt =~ s/.+:://;
        my $t = "_cached_${tt}";
        no warnings 'redefine';
        *$symbol = sub {
            my $self = $_[0];
            my $h = $self->{$t};
            if (!defined $h) {
                $self->{$t} = $h = $referent->($self);
            }
            return $h;
        };
        if ($ENV{BM_DEBUG_OBJLIB_CACHE}) {
            *$symbol = sub {
                my $self = $_[0];
                my $h = $self->{$t};
                my $sth = ($cache_stats->{$$symbol} //= {});
                if (!defined $h) {
                    my $start = Time::HiRes::time();
                    $self->{$t} = $h = $referent->($self);
                    my $call_time = Time::HiRes::time() - $start;
                    if ($self->{"_called_bits"}{$tt}) {
                        # значение должно было быть закэшировано, но пришлось вычислять заново
                        $sth->{waste_call_time} += $call_time;
                        $sth->{waste_call_count}++;
                    } else {
                        $sth->{first_call_time} += $call_time;
                        $sth->{first_call_count}++;
                    }
                    $self->{"_called_bits"}{$tt} = 1;
                } else {
                    $sth->{hit_count}++;
                }
                return $h;
            };
        }
    }
}

# кэширование, приспособленное для вызовов с rpc
# храним в объекте контекст вызова (после получения результата его удаляем)
# для корректности при одновременном вызове метода из двух мест всегда кэшируем результат
sub RPC_CACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = $$symbol;
        $tt =~ s/.+:://;
        no warnings 'redefine';
        *$symbol = sub {
            my $self = $_[0];
            my $h = ($self->{_rpc_cache_}{$tt} //= {});
            if (!exists $h->{res}) {
                my $ctx = ($h->{ctx} //= {});
                $h->{res} = [$referent->($self, $ctx)];
                delete $h->{ctx};
            }
            my $res = $h->{res};
            return wantarray ? @$res : $res->[0];
        };
    }
}

# глобальное кэширование метода
# модификаторы:
# "ARGS_HASH"
#   если есть аргументы, передаваемые в виде хэша:
#   sub method { my $self = shift; my %par = @_; .... }
#   то можно закешировать результат с учётом их
#   хэш с аргументами сериализуется json-ом
# "DERIVED"
#   если в методе вызываются другие методы, которые переопределены в производных классах
#   будем кэшировать не для того модуля, где встетился метод, а для того, где был вызван
#
# если метод вызывается для объекта, в котором выставлен флаг dont_use_globalcache, кэш игнорируется
my %global_cache;
my $global_cache_key_encoder = JSON::XS->new->canonical;
sub GLOBALCACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my %seen_modif;
        if ($data and ref($data) eq 'ARRAY') {
            $seen_modif{$_} = 1 for @$data;
        }
        my $args_hash = $seen_modif{"ARGS_HASH"};
        my $derived = $seen_modif{"DERIVED"};

        my $method_name = $$symbol;
        $method_name =~ s/.+:://;

        no warnings 'redefine';
        *$symbol = sub {
            my $self = shift;
            # может быть методом объекта или класса
            if (ref($self) eq 'HASH' and $self->{dont_use_globalcache}) {
                return $referent->($self, @_);
            }
            my $cache_name;
            if ($derived) {
                my $class = ref($self) || $self || $package;
                $cache_name = join('::', 'derived', $class, $method_name);
            } else {
                $cache_name = join('::', 'global', $package, $method_name);
            }
            if (!exists $global_cache{$cache_name}) {
                if ($args_hash) {
                    $global_cache{$cache_name} = {};
                } else {
                    $global_cache{$cache_name} = undef;
                }
            }
            my $method_cache_ref = \$global_cache{$cache_name};

            my $cache_ref;  # ссылка на переменную со значением кэша
            if ($args_hash) {
                my %args = @_;
                my $key = $global_cache_key_encoder->encode(\%args);
                my $cache = $$method_cache_ref;
                if (!exists $cache->{$key}) {
                    $cache->{$key} = undef;
                }
                $cache_ref = \$cache->{$key};
            } else {
                $cache_ref = $method_cache_ref;
            }
            my $cache_value = $$cache_ref;
            if (!defined $cache_value) {
                $cache_value = [$referent->($self, @_)];
                $$cache_ref = $cache_value;
            }
            return wantarray ? @$cache_value : $cache_value->[0];
        };
    }
}

sub GLOBALTIMECACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = $$symbol;
        $tt =~ s/(.+):://;
        my $mdl = $1;
        $mdl =~ s/^\*//;
        my $cache_time = $mdl.'::_glcachedtime_'.${tt};
        my $cache_var = $mdl.'::_glcached_'.${tt};
        my $timeout = $data->[0];
        {
            no strict 'refs';
            $$cache_var = undef;
            $cache_var = \$$cache_var;
            $$cache_time = undef;
            $cache_time = \$$cache_time;
        }
        no warnings 'redefine';
        *$symbol = sub {
            my $self = shift;
            return $referent->($self) if $self->{'dont_use_globalcache'};
            $$cache_var = [$referent->($self)] if (! defined $$cache_var) || (! $$cache_time) || (time - $$cache_time > $timeout);
            $$cache_time = time;
            return wantarray ? @{ $$cache_var } : exists( ${ $$cache_var }[0] ) ? ${ $$cache_var }[0] : undef;
        };
    }
}

sub TABLECACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        #my $t = scalar($symbol);
        my $tt = $$symbol;
        $tt =~ s/(.+):://;
        my $mdl = $1;
        $mdl =~ s/^\*//;
        my $param_name = $mdl.'::'.${tt};
        my $cache_var  = $mdl.'::_tblcached_'.${tt};
        my $cache_time = $mdl.'::_cachetime_tblcached_'.${tt};
        {
            no strict 'refs';
            $$cache_var = undef;
            $cache_var = \$$cache_var;
            $$cache_time = undef;
            $cache_time = \$$cache_time;
        }
        my $table_name = $data->[0];     #Имя таблицы
        my $table_dbh_name = $data->[1]; #Если другой dbh
        my $table_param = $data->[2] || 'Update_time'; #Имя параметра таблицы (например, может проверяться Rows или Index_length) 
        my $dont_use_session_cache = $data->[3];  #Нужно ли кэшировать проверку на сессию - проверка таблицы будет на каждый вызов
        #($table_name =~ s/(.+)\-\>//) ? $1 : undef; #Если префиксом к таблице указано название dbh, то вырезаем его
        #print "Content-type: text/html\n\neee\n\n\n<br><br><br>";
        #print "[ $attr, $data->[0], $table_name, $table_dbh_name, $table_param, $session_cache]<br>\n";
        #exit;
        no warnings 'redefine';
        *$symbol = sub {
            my $self = shift;
            return $referent->($self) if $self->{'dont_use_tablecache'};
            my $proj = $self->can('proj') ? $self->proj : $self; #Чтобы можно было использовать как для проджекта, так и для других объектов
            my $table_time = '';
            $table_time = $proj->{_session_cache}{'_tablecache_'.$param_name} unless $dont_use_session_cache; #Берём закэшированное из сессии значение времени таблицы, если есть
            unless($table_time){
	        #print "Content-type: text/html\n\neee\n\n\n<br><br><br>";
                #print "WWWWWWWWWW<br>\n"; 
                $table_time = $proj->dbtable($table_name, undef, $table_dbh_name)->table_status->{$table_param};
            }
            my $renew =  #Нужно ли обновлять 
                    (! defined $$cache_time ) #Ещё нет кэша
                 || ( $$cache_time ne $table_time ); #Время изменения таблицы другое
            #print "[ $$cache_time, $table_time, $renew ]";
            if( $renew ){
	        #print "Content-type: text/html\n\neee\n\n\n<br><br><br>";
                #print "EEEEEEEE  $table_time === $$cache_time <br>\n"; 
                $$cache_var = [$referent->($self)] if $renew;
                $$cache_time = $table_time;
            }
            $proj->{_session_cache}{'_tablecache_'.$param_name} = $table_time;
            return wantarray ? @{ $$cache_var } : exists( ${ $$cache_var }[0] ) ? ${ $$cache_var }[0] : undef;
#            return @{ $self->{$t} };
        };
    }
}

sub FILECACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        #my $t = scalar($symbol);
        my $tt = $$symbol;
        $tt =~ s/.+:://;
        my $t = "_cached_${tt}";
        my $timeout = $data->[0] || 3600;     #Таймаут
        no warnings 'redefine';
        *$symbol = sub {
            my $self = shift;
            return $referent->($self) if $self->{'dont_use_cache'};
            unless( defined $self->{$t} ){
                my $proj = $self->can('proj') ? $self->proj : $self; #Чтобы можно было использовать как для проджекта, так и для других объектовa
                unless($self->{'no_filecache'}){
                    my $dir = $proj->options->{dirs}{temp}.'/FileCache/'.$$symbol;
                    $dir =~ s/::/\//g;
                    $dir =~ s/[^-A-Za-z0-9_\/]//g;
                    -d $dir || make_path( $dir ); # || warn "can't create dir:  $!\n";
                    my $elem_id = $self->can('cache_id') ? $self->cache_id : md5_hex("$self");
                    my $filename = $dir."/data_$elem_id";
                    #print Dumper([ $elem_id, $filename,  $dir, (-d $dir), (time - (stat $filename)[9]) ]);
                    my $filedataflag = 0; 
                    if( (-e "$filename") && ( time - (stat $filename)[9] < $timeout ) && !$self->{dont_read_from_filecache} ){
                        $filedataflag = 1;
                        open(F, "< $filename") or warn "filecache: $!";
                        my @a = <F>;
                        close(F);
                        my $text = join("", @a);
                        eval { #Данные в файле могут быть по какой-то причине повреждены
                            $self->{$t} = $self->proj->json_obj->decode($text);
                        };
                        if($@){
                            $filedataflag = 0;
                        }
                    }
                    if(! $filedataflag){ #Не удалось получить данные из файла
                        $self->{$t} = [$referent->($self)];
                        my $text = $self->proj->json_obj->encode( $self->{$t} );
                        my $tmpfile = "${filename}_". $$ ."_tmp";
                        if( open(F, "> $tmpfile")){
                            print F $text;
                            close(F);
                        }
                        rename($tmpfile, $filename); #Решаем проблему недописанных файлов
                    }
                }else{
                    $self->{$t} = [$referent->($self)] unless defined $self->{$t};
                }                
            }
            return wantarray ? @{ $self->{$t} } : exists( $self->{$t}[0] ) ? $self->{$t}[0] : undef;
#            return @{ $self->{$t} };
        };
    }
}

# для методов, которые должны отработать только один раз
# не запоминаем возвращаемое значение - в этом отличие от GLOBALCACHE
sub RUN_ONCE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $called = 0;
        no warnings 'redefine';
        *$symbol = sub {
            return if $called;
            $called = 1;
            return $referent->(@_);
        };
    }
}   

# Подсчёт количества вызовов метода, вызвавшего данный метод. Например:
# $self = {
#     'calls_count' => {
#         'BM::BannersMaker::BannerLandProject::init' => 1,
#         'BaseProject::init' => 2,
#         'Project::init' => 1,
# }}
sub get_calls_count_and_inc {
    my $self = shift;
    my (undef, undef, undef, $subroutine) = caller(1);
    return $self->{calls_count}{$subroutine}++;
}

1;
