package ObjLib::ProjPart;

# Абстрактный класс, от которого должны наследовать модули проекта
# Реализует доступ к объекту проекта

use std;
use base qw(ObjLib::Obj);
use Encode qw{_utf8_on};

use Utils::Sys;                 # для md5
use Utils::Common;

use Storable;

__PACKAGE__->mk_accessors(qw(
    work_dir
));

########################################################
#Конструктор
########################################################

my $CACHE_STATS_KEY = '__ProjPart_cache_stats';

#Переопределяем, добавляя фичу
sub new {
    my $self = ObjLib::Obj::new(@_);
    # переставляем ссылку на proxy_ref
    my $proj = $self->{proj};
    $self->{proj_proxy_ref} = $proj->proxy_ref;
    delete $self->{proj};

    # default для метода lang
    $self->{proj_current_lang} = $proj->current_lang;

    return $self;
}

# сейчас статистика ведётся только по KYOTOCACHEHASHREF
sub cache_stats {
    my $self = shift;
    return ($self->{$CACHE_STATS_KEY} //= {});
}

sub new_lite {
    my $proto = shift;
    my $self = shift;
    my $class  = ref($proto) || $proto; #Класс, к которому приводим
    bless($self, $class);
    return $self;
}

########################################################
#Доступ к полям
########################################################
#@returns Project
sub proj {
    my $self = shift;
    if ($self->{proj}) { # в ObjLib::Obj::new вызывается init, там ещё proj, а не proxy_ref
        return $self->{proj};
    } else {
        my $ref = $self->{proj_proxy_ref};
        return $$ref;
    }
}

sub log {
    my $self = shift;
    my @args = @_;
    $self->proj->log(@args);
}
;

sub lang {
    my $self = shift;
    if (@_) {
        $self->{lang} = $_[0];
    }
    return $self->{lang} // $self->{proj_current_lang};
}
#@returns BM::Language
sub language {
    my $self = shift;
    return $self->{language} //= $self->proj->get_language($self->lang);
}

sub do_sys_cmd {
    my $self = shift;
    $self->proj->do_sys_cmd(@_);
}

sub do_sys_cmd_bash {
    my $self = shift;
    $self->proj->do_sys_cmd_bash(@_);
}

sub read_sys_cmd {
    my $self = shift;
    return $self->proj->read_sys_cmd(@_);
}

sub temp_dir {
    my $self = shift;
    return $self->{temp_dir} || $self->proj->temp_dir;
}

sub get_tempfile {
    my $self = shift;
    my $name = shift || 'projpart_tmp';
    my %par  = (
        DIR => $self->temp_dir,
        @_,
    );
    return $self->proj->get_tempfile($name, %par);
}

sub histinf {
    my $self = shift;
    return $self->{'histinf'};
}

sub set_histinf {
    my ($self, $dt) = @_;
    $self->{'histinf'} = $dt;
}

sub add_histinf {
    my ($self, $dt) = @_;
    $self->{'histinf'} .= $self->{'histinf'} ? "->$dt" : $dt;
}

#Причина фильтрации
sub fltrsn {
    my $self = shift;
    return $self->{'fltrsn'};
}

sub add_fltrsn {
    my ($self, $dt) = @_;
    $self->{'fltrsn'} .= $self->{'fltrsn'} ? ",$dt" : $dt;
}

sub TIMELOG : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        no warnings 'redefine';
        *$symbol = sub {
            my ($self) = @_;
            $self->proj->timelogbeg("sub $package $name");
            my @res = $referent->(@_);
            $self->proj->timelogend("sub $package $name");
            return wantarray ? @res : exists( $res[0] ) ? $res[0] : undef;
        };
    }
}

sub KYOTOCACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    my $t = $$symbol;
    $t =~ s/.+:://;
    no warnings 'redefine';
    *$symbol = sub  {
        my $self = shift;
        my $proj = $self->proj;

        return $referent->($self, @_) if @_; #В случае аргументов не кэшируем TODO: надо переделать
        return $referent->($self) if $self->{'dont_use_cache'};
        return $referent->($self) unless $self->can('get_remotecache_id');
        return $referent->($self) unless $self->get_remotecache_id; # если нулевой значение - плохо.

        my $ktclient    = $proj->ktclient();
        my $salt        = $Utils::Common::options->{kyoto}{salt};


        my $key = md5int_base64($t . $salt) . '_' .md5int_base64($self->get_remotecache_id);
        # t - имя функции, get_remotecache_id - скалярное представление id аргумента

        if ( !($proj->{'dont_read_remotecache'}) ) { # если можно читать из кэша

            # если смогли прочитать из кэша - вернем все что нужно
            my $remote_value = Storable::thaw($ktclient->get($key));

            # правильное значени всегда массив
            if ( defined($remote_value) && ref($remote_value) eq 'ARRAY' ) {
                return wantarray ? @$remote_value : exists( $remote_value->[0] ) ? $remote_value->[0] : undef;
            }
        }

        # вызовем функцию непосредственно
        my @function_value = $referent->($self);

        # сохраним закэшированное значение
        if ( !($proj->{'dont_write_remotecache'}) ) {
            # 2 weeks по умолчанию протухать
            my $expiration_secs =  ( exists($data->[0]) && int($data->[0]) > 0 && int($data->[0]) < 1_000_000_000 ) ? int($data->[0]) : 7 * 24 * 3600;
            my $set_result = $ktclient->set( $key, Storable::freeze(\@function_value), $expiration_secs );
        } else {
        }

        return wantarray ? @function_value : exists( $function_value[0] ) ? $function_value[0] : undef;
    };
}

# органичения на импользования этого атрибута
# 1. ПЕРВЫЙ параметр - ссылка на массив скаляров
# 2. РЕЗУЛЬТАТ функции - ссылка на хэш, в котором ключи - это скалярные значения из первого параметра
sub KYOTOCACHEHASHREF : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    my $t = $$symbol;
    $t =~ s/.+:://;
    no warnings 'redefine';
    my $expiration_time =  ( exists($data->[0]) && int($data->[0]) > 0 && int($data->[0]) < 1_000_000_000 ) ? int($data->[0]) : 7 * 24 * 3600;
    *$symbol = sub  {
        my $self = shift;
        my $keys = shift;
        my @args = @_;

        my $proj = $self->proj;

        return $referent->($self, $keys, @args) if $self->{'dont_use_cache'}; # явно указано не использовать кэш

        my $cache_stats = ($self->cache_stats->{KYOTOCACHEHASHREF}{$t} //= {});

        # получим из массива скаляров массив remotecacheid

        # kyoto client
        my $ktclient    = $proj->ktclient();
        my $salt        = $Utils::Common::options->{kyoto}{salt};
        my $all_keys_hash = { map { md5int_base64($t) . '_' .md5int_base64($_ . $salt) => $_ } @$keys };
        my @load_keys = keys %$all_keys_hash;
        my ( @found_keys, @not_found_keys ) = ( (), () );
        my %hash_result = ();

        # размеры пачек для чтения/записи в киото - если пачки будут больше, то запись в киото может не происходить
        my $read_pack_size = 100;
        my $write_pack_size = 100;

        while ( @load_keys ) {
            my @keyspack = splice(@load_keys, 0, $read_pack_size);
            my $current_hash = $ktclient->get_multi( @keyspack );

            # десериализация
            for my $key ( keys %$current_hash ) {
                $hash_result{ $all_keys_hash->{$key} } = Storable::thaw( $current_hash->{ $key } );
            }
            exists( $current_hash->{ $_ } ) ? push( @found_keys, $_ ) : push( @not_found_keys, $_ ) for @keyspack;
        }
        $cache_stats->{miss} += @not_found_keys;
        $cache_stats->{hit} += @found_keys;

        # если есть ненайденные ключи в кэше
        if (@not_found_keys) {
            my %hash_not_found_result = %{$referent->( $self, [ map { $all_keys_hash->{$_} } @not_found_keys ], @args )};

            my @set_multi_array = ();
            for my $not_found_key ( @not_found_keys ) {
                if ( exists($hash_not_found_result{ $all_keys_hash->{$not_found_key} }) ) {
                    push @set_multi_array, [ $not_found_key, Storable::freeze($hash_not_found_result{ $all_keys_hash->{$not_found_key} }, ), $expiration_time ];
                }
            }

            while (@set_multi_array) {
                my @set_pack = splice(@set_multi_array, 0, $write_pack_size);
                $ktclient->set_multi(@set_pack);
            }

            # сохраним
            %hash_result = ( %hash_result, %hash_not_found_result );
        }

        return \%hash_result;

    };
}


sub REMOTECACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        #my $t = scalar($symbol);
        my $t = $$symbol;
        $t =~ s/.+:://;
        no warnings 'redefine';
        *$symbol = sub {
            my $self = shift;
            my $proj = $self->proj;
            my $cachedfield = "_cached_$t";
            if ( $self->{$cachedfield} ) { #Данные получены пакетной обработкой
                return wantarray
                ? ( ref($self->{$cachedfield}) eq 'ARRAY' ? @{$self->{$cachedfield}} : $self->{$cachedfield} )
                : ( ref($self->{$cachedfield}) eq 'ARRAY'
                    ? ( exists( $self->{$cachedfield}[0] ) ? $self->{$cachedfield}[0] : undef )
                    : $self->{$cachedfield}
                );
            }
            return $referent->($self, @_) if @_; #В случае аргументов не кэшируем
            return $referent->($self) if $self->{'dont_use_cache'};
            return $referent->($self) unless $self->can('get_remotecache_id');

            my $key = md5int_base64($t) . '_' .md5int_base64($self->get_remotecache_id);

            my $memcached_server    = $proj->memclient();

            if ( !($proj->{'dont_read_remotecache'}) ) {
                my $m_value         = $memcached_server->get($key);
                $self->{$cachedfield} = $m_value;
                if ( defined($m_value) && ref($m_value) eq 'ARRAY' ) {
                    my @res = @$m_value;
                    return wantarray ? @res : exists( $res[0] ) ? $res[0] : undef;
                } elsif ( defined($m_value) && ! ref($m_value) ) {
                    _utf8_on($m_value);
                    return $m_value;
                }
            }

            my @res = $referent->($self);
            if ( !($proj->{'dont_write_remotecache'}) ) {
                my $set_value = \@res;
                my $s_revult = $memcached_server->set( $key, $set_value, 14 * 24 * 3600 );
            }
            $self->{$cachedfield} = \@res;

            return wantarray ? @res : exists( $res[0] ) ? $res[0] : undef;
        };
    }
}

sub REMOTECACHELIST : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        #my $t = scalar($symbol);
        my $t = $$symbol;
        my ($source, $cachemethod, $cachetimeout) = @$data;
        $cachetimeout ||= 14 * 3600 * 24;
        no warnings 'redefine';
        *$symbol = sub {
            my ($self) = @_;
            my @list = $self->$source;
            my $proj = $self->proj;
            return if $self->{'dont_use_cache'} || $proj->{'dont_use_cache'};

            my $els = { map { md5int_base64($cachemethod).'_'.md5int_base64($_->get_remotecache_id) => $_ } @list };
            my @ckeys = keys %$els;

            my $clh = $proj->memclient;

            my @load_keys = @ckeys;
            my (@oldkeys, @newkeys) = ();
            my %hash_result = ();
            while ( @load_keys ) {
                my @keyspack = splice(@load_keys, 0, 100);
                my $current_hash = $clh->get_multi( @keyspack );
                exists($current_hash->{ $_ }) ? push(@oldkeys, $_) : push(@newkeys, $_) for @keyspack;
                %hash_result = ( %hash_result, %$current_hash );
            }
            for my $el ( @oldkeys ) {
                $els->{$el}{"_cached_$cachemethod"} = $hash_result{$el};
                _utf8_on($els->{$el}{"_cached_$cachemethod"}) unless ref($els->{$el}{"_cached_$cachemethod"});
            }

            return unless @newkeys > 1; #Не делаем пакетной обработки, если элементов меньше 2

            my %newhash_result = ();
            my @res = $referent->($self, map { $els->{$_} } @newkeys);
            if (@res && (@res == @newkeys)) {
                $newhash_result{$newkeys[$_]} = $res[$_]  for 0 .. $#newkeys;
                my @set_array = map { [ $newkeys[$_], $res[$_], $cachetimeout ] } 0 .. $#newkeys;
                while ( @set_array ) {
                    $clh->set_multi( splice(@set_array, 0, 100));
                }
                $els->{$_}{"_cached_$cachemethod"} = $newhash_result{$_} for @newkeys;
            } else {
                #не кэшируем, кэширование делается при получении данных
            }
        };
    }
}

sub LANG : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        no warnings 'redefine';
        *$symbol = sub {
            my ($self) = @_;
            my $proj = $self->proj;
            my @res;
            my $self_lang = $self->lang;
            if ( $self_lang && ($self_lang ne $proj->current_lang) ) {
                my $prevlang = $proj->current_lang;
                $proj->current_lang($self_lang);
                @res = $referent->(@_);
                $proj->current_lang($prevlang);
            } else {
                @res = $referent->(@_);
            }
            return wantarray ? @res : exists( $res[0] ) ? $res[0] : undef;
        };
    }
}


sub FLTR : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        no warnings 'redefine';
        *$symbol = sub {
            my ($self) = @_;
            my $res = $referent->(@_);
            if (( ! $self->{dont_use_fltr_log} ) && (ref($res) eq ref($self))) {
                my $badobj = $self - $res;
                $_->add_fltrsn($name) for @$badobj;
            }
            return $res;
        };
    }
}

sub PACKETIZE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $psize = 20000;
        my $name = $2;
        no warnings 'redefine';
        *$symbol = sub {
            my ($self) = shift;
            my $res;
            if ($self->count > $psize) {
                my @arr = ();
                for my $lst ($self->split_by_count($psize)) {
                    my $lres = $referent->($lst, @_);
                    push(@arr, $lres);
                }
                $res = $self->new_listobj([ map {@$_} @arr ]);
            } else {
                $res = $referent->($self, @_);
            }
            return $res;
        };
    }
}

my $default_context = "_default_context";
my $externally_used_list = {};
sub EXTERNALLY_USED : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;

    my @contexts;
    @contexts = grep { defined($_) && length($_) } @$data if ref($data) eq 'ARRAY';
    @contexts = ($default_context) unless scalar(@contexts) > 0;

    my $sub_name = substr(scalar(*$symbol), 1); #Cut * from *BM::PhraseList::parse
    $externally_used_list->{$_}->{$sub_name} = 1 for @contexts;
}

sub can_be_externally_used {
    my $self = shift;
    my $method = shift;
    my $context = shift // $default_context;

    my $list_for_context = $externally_used_list->{$context};
    return undef unless defined $list_for_context;

    for my $package_sub (keys %$list_for_context) {
        $package_sub =~ m!(.*)::(.*)!;
        my ($package, $sub) = ($1, $2);
        return 1 if ($sub eq $method) && $self->isa($package);
    }

    return undef;
}

sub FREEZE {
    my $self = shift;
    my %copy;
    while (my ($k, $v) = each %$self) {
        next if $k eq 'proj_proxy_ref';
        next if $k eq 'proj';
        next if $k eq $CACHE_STATS_KEY;
        $copy{$k} = $v;
    }
    return \%copy;
}

# аналог CACHE, но с дополнительным контуром кэширования в виде вытесняющего кэша
# сначала идем за значением в локальный ключ, если там нет - в lru-кэш, а если и там нет - выполняем целевой метод
# в качестве уникального ключа используется get_remotecache_id. Если его нет - все работает аналогично декоратору CACHE
sub LRUCACHE : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {
        my $func = $$symbol;
        $func =~ s/.+:://;
        my $local_func = '_lru_cache_copy_' . $func;
        no warnings 'redefine';
        *$symbol = sub {
            my $self = shift;

            my $h;
            if (exists $self->{$local_func}) {
                $h = $self->{$local_func};
            }
            if ( !defined $h ) {
                my $class = ref($self) || $self || $package;
                my $cache_namespace = join('::', $class, $func);
                my $remote_id;
                if ( !$self->{dont_use_lru_cache} && $self->can('get_remotecache_id') ) {
                    local $self->{dont_use_lru_cache} = 1; #защита от зацикливания
                    $remote_id = $self->get_remotecache_id;
                }

                if ( $remote_id ) {
                    $h = $self->proj->lru_cache->get($remote_id, $cache_namespace);
                }
                if (!defined $h) {
                    $h = [$referent->($self)];
                    if ( $remote_id ) {
                        $self->proj->lru_cache->set($remote_id, $h, $cache_namespace);
                    }
                }
                $self->{$local_func} = $h;
            }
            return wantarray ? @$h : $h->[0];
        };
    }
}

# декоратор с вытесняющим кэшированием для функций, работающих с массивами
# можно навесить на функцию, которая
# 1) принимает на вход arrayref
# 2) возвращает arrayref
# 3) над входным arrayref совершает какую-либо мап-операцию, не меняя число и порядок элементов на выходе
sub LRUCACHELIST : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {   
        my $func = $$symbol;
        $func =~ s/.+:://;
        no warnings 'redefine';
        *$symbol = sub {
            my $self = shift;
            my $input_list = shift;

            my $class = ref($self) || $self || $package;
            my $cache_namespace = join('::', $class, $func);

            my %index_to_resp = ();
            my @send_index_arr = ();
        
            for my $i (0..$#$input_list) {
                my $cached_resp = $self->proj->lru_cache->get($input_list->[$i], $cache_namespace );
                $index_to_resp{$i} = $cached_resp;
                if ( !defined $cached_resp ) {
                    push @send_index_arr, $i;
                }
            }
            if ( @send_index_arr ) {
                my $send_list = [ map {$input_list->[$_]} @send_index_arr ];
                my $resp_list = $referent->($self, $send_list);
                if ( !defined $resp_list ) {
                    $self->log("WARN: LRUCACHELIST function call returned undef: $cache_namespace");
                    return undef;
                }
                if ( scalar(@$resp_list) != scalar(@send_index_arr) ) {
                    die "Error in LRUCACHELIST function call: response count doesnt match request count";
                }
                for my $i (0..$#send_index_arr ) {
                    my $orig_index = $send_index_arr[$i];
                    $index_to_resp{$orig_index} = $resp_list->[$i];
                    $self->proj->lru_cache->set( $input_list->[$orig_index], $resp_list->[$i], $cache_namespace );
                }
            }
            my $final_list = [ map { $index_to_resp{$_} } sort {$a <=> $b} keys %index_to_resp ];
            return $final_list;
        };
    }
}


1;
