=encoding UTF-8

=cut

=head1 Название

ObjLib::StateActions

=head1 Описание    

Абстрактный класс, определяющий работу со статусами

Нужно обязательно переопределить методы getState и setState

=cut

# взято отсюда:
# https://svn.yandex.ru/partner/trunk/lib/ObjLib/StateActions.pm

package ObjLib::StateActions;

use base qw(ObjLib::ProjPart);

use Utils::DB qw(array2text);

use std;

__PACKAGE__->mk_accessors(qw(
    dbt
    log_dbt
));

sub init {
    my $self = shift;
    if ($self->{dbt_params}) {
        $self->dbt($self->proj->dbtable(@{$self->{dbt_params}}));
    }
    if ($self->{log_dbt_params}) {
        $self->log_dbt($self->proj->dbtable(@{$self->{log_dbt_params}}));
    }
}

# асессор ко графу статусов
sub states {
    my $self = shift;
    if(@_){$self->{'states'} = shift;}
    return $self->{'states'};
}

# Получить статус
sub getState {
    my ($self,$id) = @_;
    my $stf = $self->{fld}{state} || 'state';
    my $h = $self->dbt->Get($id) // {};
    return $h->{$stf};
}

# Установить статус
sub setState {
    my ($self,$id,$state) = @_;
    my $stf = $self->{fld}{state} || 'state';
    my $date = $self->proj->dates->cur_date('db_time');
    $self->dbt->Edit($id, { $stf => $state, UpdateTime => $date });
}

sub logAction {
    my ($self, $info) = @_;
    my %data = map { ($self->{fld}{$_} || $_) => $info->{$_} } qw(old_state new_state action);
    $data{ $self->dbt->id_field } = $info->{item_id};
    $data{UpdateTime} = $self->proj->dates->cur_date('db_time');
    $self->log_dbt->Add(\%data);
}

sub init_log_table {
    my $self = shift;
}

sub logActionMulti {
    my ($self, $data) = @_;
    return if !@$data;

    $self->init_log_table;
    my $id_fld = $self->log_dbt->id_field;
    my @fld = ($id_fld, map { $self->{fld}{$_} // $_ } qw(old_state new_state action));

    my @values;
    for my $inf (@$data) {
        my %data = map { ($self->{fld}{$_} // $_) => $inf->{$_} } qw(old_state new_state action);
        $data{$id_fld} = $inf->{item_id};
        push @values, \%data;
    }

    my $log_tbl = $self->log_dbt->db_table;
    my $dbh = $self->log_dbt->dbh;
    $self->log_dbt->{sql_log} = 1;
    $dbh->do("
        insert into $log_tbl (".join(',', @fld).")
        values ".array2text($dbh, \@values, fields => \@fld)."
    ");
}

=head2 getActions 

B<Параметры:> 1) uid

B<Возвращаемое значение:>

Получить список действий, которые возможны

    my $acts = $self->proj->users->getActions(35309619);

=cut

sub getActions {
    my ($self,$id) = @_;
    return $self->states->get_actions($self->getState($id));
}

=head2 checkStateAgainstFilter 

B<Параметры:>

B<Возвращаемое значение:>

=cut

sub checkStateAgainstFilter {
    my ($self, $state, $filter) = @_;
    return $self->states->check_state_against_filter($state, $filter)
}

=head2 checkAgainstFilter 

B<Параметры:>

B<Возвращаемое значение:>

=cut

sub checkAgainstFilter {
    my ($self, $id, $filter) = @_;
    return $self->checkStateAgainstFilter($self->getState($id), $filter);
}

=head2 checkAction

B<Параметры:>

B<Возвращаемое значение:>

Проверяет возможность действия

=cut

sub checkAction {
    my ($self,$id,$act) = @_;
    my $acts = $self->getActions($id);
    return exists $acts->{$act} ? $acts->{$act} : '';
}

=head2 checkOneOfActions

B<Параметры:>

B<Возвращаемое значение:>

Проверяет возможность действия. Удобно для проверки группы статусов.

=cut

sub checkOneOfActions {
    my ($self,$id,$try_act) = @_;
    my $has_acts =[keys  %{ $self->getActions($id) } ];
    return is_intersect($has_acts, $try_act);
}

=head2 makeAction 

B<Параметры:>

B<Возвращаемое значение:>

Выполнить действие, возвращает новое состояние или undef в случае неудачи

=cut


sub lock_id {
    my ($self, $id) = @_;
    my $dbh = $self->dbh;
    my $str = $self->states->current_type."_state_$id";
    my $res = $dbh->selectrow_arrayref("select get_lock('$str', 0)")
        or $self->log("ERROR: can't try to get lock for id=$id: ".$dbh->errstr) and return;
    return $res->[0];
}

sub unlock_id {
    my ($self, $id) = @_;
    my $dbh = $self->dbh;
    my $str = $self->states->current_type."_state_$id";
    my $res = $dbh->selectrow_arrayref("select release_lock('$str')")
        or $self->log("ERROR: can't try to release lock for id=$id: ".$dbh->errstr) and return;
    return $res->[0];
}

sub makeAction {
    my ($self,$id,$act) = @_;

    my $old_state = $self->getState($id);
    my $new_state = ($self->states->get_actions($old_state) || {})->{$act};
    return if !$new_state;  # действие выполнить нельзя

    return if !$self->lock_id($id);

    # проверим, что статус не поменялся, пока брали лок
    if ($self->getState($id) ne $old_state) {
        $self->unlock_id($id);
        return;
    }

    # можно делать действие
    $self->setState($id, $new_state);
    $self->logAction({
            'type'       => $self->states->current_type,
            'item_id'    => $id,
            'old_state'  => $old_state,
            'action'     => $act,
            'new_state'  => $new_state,

        });
    $self->unlock_id($id);
    return $new_state;
}

=head2 getAllActionStates 

B<Параметры:>

B<Возвращаемое значение:>

Получение статусов, между которыми есть переход указанным действием

=cut

sub getAllActionStates {
    my ($self,$action) = @_;
    return $self->states->get_states_by_action($action);
}

=head2 getActionStates 

B<Параметры:>

B<Возвращаемое значение:>

Возвращает массив статусов по действию

=cut

sub getActionStates {
    my ($self, $act) = @_;
    if(ref($act) eq 'ARRAY'){
        my @arr = ();
        push(@arr, @{$self->states->get_states_by_action_out($_)}) for @$act;
        return \@arr;
    }elsif( $act =~ /\s|[-+]/){
        return $self->states->get_states_by_actions_line($act);
    }else{
        return $self->states->get_states_by_action_out($act);
    }
}


=head2 getActionStates_in

B<Параметры:>

B<Возвращаемое значение:>

Возвращает список статусов, у которых это действие входящее

=cut

sub getActionStates_in {
    my ($self, $act) = @_;
    return $self->states->get_states_by_action_in($act);
}

=head2 getStateActions

B<Параметры:>

B<Возвращаемое значение:>

Получить возможные действия для состояния (хеш)

=cut

sub getStateActions {
    my ($self, $state) = @_;
    return $state ? $self->states->get_states_hash->{$state} : {};
}

# список ID в одном из заданных состояний
sub getIdsByStates {
    my ($self, $starr, %par) = @_;
    my $st_fld = $self->{fld}{state};
    my $id_fld = $self->dbt->id_field;
    my $data = $self->dbt->List({$st_fld => $starr});
    return map { $_->{$id_fld} } @$data;
}

# список ID, для которых можно сделать действие
# %par - дополнительные параметры для наследуемых методов
sub getIdsByAction {
    my ($self, $act, %par) = @_;
    $self->getIdsByStates($self->states->get_states_by_action_out($act), %par);
}

# список ID, которые могли возникнуть при действии
# %par - дополнительные параметры для наследуемых методов
sub getIdsByActionIn {
    my ($self, $act, %par) = @_;
    $self->getIdsByStates($self->states->get_states_by_action_in($act), %par);
}

1;
