package ObjLib::Timer;
use strict;

use JSON qw();
use Time::HiRes;

use base qw(ObjLib::Obj);

# параметры:
#   prefix_sep  =>  разделитель между префиксом и именем
sub init {
    my $self = shift;
    $self->reset;

    $self->{prefix_sep} //= ':';
    $self->{prefixes} = [];
    $self->_set_full_prefix;
}

# начать замер времени для данного имени
sub time {
    my $self = shift;
    my $name = shift;
    $self->_split;
    $self->{prev_name} = $self->{curr_name};
    $self->{curr_name} = $name;
    $self->{on_hold} = 0;
}

# продолжить замер времени для предыдущего имени
sub time_prev {
    my $self = shift;
    my $name = $self->{prev_name} // 'unknown';
    $self->time($name);
}

# ставить префикс перед именами
# $timer->set_prefix('run');
# $timer->time('start');  # замеряет "run:start"
# $timer->time('parse');  # замеряет "run:parse"
sub set_prefix {
    my $self = shift;
    my $prefix = shift;
    $self->{prefixes} = [ $prefix ];
    $self->_set_full_prefix;
}

# append/pop prefix - работа со списком префиксов
# $timer->append_prefix('run');
# $timer->append_prefix('parse');
# $timer->time('stage1');  # замеряет "run:parse:stage1"
# $timer->time('stage2');  # замеряет "run:parse:stage2"
# $timer->pop_prefix;
# $timer->time('process');  # замеряет "run:process"
sub append_prefix {
    my $self = shift;
    my $prefix  = shift;
    push @{$self->{prefixes}}, $prefix;
    $self->_set_full_prefix;
}
sub pop_prefix {
    my $self = shift;
    pop @{$self->{prefixes}};
    $self->_set_full_prefix;
}

# остановить таймер
sub hold {
    my $self = shift;
    $self->_split;
    $self->{on_hold} = 1;
}

# хэш { $name => $time }
sub report {
    my $self = shift;
    $self->_split;
    return $self->{timings};
}

# сериализованный хэш { $name => $time }
sub report_str {
    my $self = shift;
    my $report = $self->report;
    return JSON::to_json($report, { utf8 => 0, pretty => 0});
}

sub reset {
    my $self = shift;
    $self->{timings} = {};
    $self->{curr_name} = undef;
    $self->{on_hold} = 0;
}

sub _set_full_prefix {
    my $self = shift;
    $self->time('_');
    my $sep = $self->{prefix_sep};
    $self->{full_prefix} = join($sep, @{$self->{prefixes}});
    $self->{full_prefix} .= $sep if $self->{full_prefix};
}

sub _split {
    my $self = shift;
    my $time = Time::HiRes::time();
    if (defined $self->{curr_name} and !$self->{on_hold}) {
        $self->{timings}{$self->{full_prefix} . $self->{curr_name}} += ($time - $self->{start_time});
    }
    $self->{start_time} = $time;
}

1;
