package Project;

use strict;
use warnings;

use base qw(IronProject BM::BannersMaker::BannerLandProject);

use ObjLib::StateActions;

sub init {
    my $self = shift;
    return if $self->get_calls_count_and_inc();

    my @parents = our @ISA;
    { #Dispatch table used to explicitly add method usages in code
        'IronProject' => \&IronProject::init,
        'BM::BannersMaker::BannerLandProject' => \&BM::BannersMaker::BannerLandProject::init,
    }->{$_}->($self) for @parents;
}

# Проверяем подключение к dbh
sub dbh_test {
    my ($self, $dbh_names, %par) = @_;
    my @dbh_names = ref($dbh_names) eq 'ARRAY' ? @$dbh_names : ($dbh_names);

    my %dbh = %{$self->{dbhlist}};
    $dbh{banners_dbh} = $self->bf->banners_dbh;

    my @dbh;
    for my $name (@dbh_names) {
        push @dbh, [$name, $dbh{$name}];
    }

    my @errors;
    for my $h (@dbh) {
        my ($name, $dbh) = @$h;
        $self->log("trying dbh $name ...");
        my $dbh_params = $dbh->get_connect_params;

        # Выводим параметры коннекта в лог, но с затёртым паролем
        my @log_dbh_params = @$dbh_params;
        $log_dbh_params[2] = "******";
        $self->log("params: " . $self->json_obj->encode(\@log_dbh_params));

        if ($par{cmd}) {
            my ($connect, $user, $pass) = @log_dbh_params;
            my %connect = map { split /=/, $_, 2 } split /;/, $connect;
            my $cmd = sprintf "mysql --user=%s --host=%s --port=%d --password=%s --database=%s",
                $user, $connect{host}, $connect{port}, $pass, $connect{'dbi:mysql:database'};
            $self->log("connect cmd: $cmd");
        }
        eval {
            $dbh->do("show tables");
        };
        if ($@) {
            $self->log("result: FAIL: $@");
            push @errors, $name;
        } else {
            $self->log("result: OK");
        }
    }
    if (@errors) {
        return 0;
    }
    return 1;
}

1;
