package QTests;

use strict;
use warnings;
use utf8;
use open ':utf8';

use base qw(ObjLib::Attr);

use Data::Dumper;
use Time::HiRes;
use Utils::Sys qw(uniq file_bytes);
use BM::Pages::Page;

#Тесты для проверки работоспособности

sub qtest_rules :QTESTRULES {
    my @lngv = qw( qtest_base_normalization qtest_base_synonyms qtest_comma_bug qtest_utils_filter );
    my @cdict = qw( qtest_cdict_search_count qtest_cdict_search_count_reg qtest_cdict_search_query_count );
    my @ml = qw( qtest_matrixnet qtest_dssm );
    {
        'catmedia catmedia-dev' => [
            'qtest_random_banners',
            'qtest_bender',
            @lngv,
            @cdict,
        ],
        'bmfront' => [
            @lngv,
            @cdict,
            @ml,
            qw/qtest_zora/,
            qw/qtest_broad_kyoto/,
            'qtest_sigpipe',
        ],
        'bmapi bmapi-test bmapi-qloud bmapi-qloud bmapi-qloud-test' => [
            @lngv,
        ],
        'bm-dev' => [
            @lngv,
        ],
        'bannerland bannerland_idle' => [
            @lngv,
        ],
        'catalogia-media-scripts catalogia-media-scripts_idle' => [
            @lngv,
        ],
        'random-banners' => [
            @lngv,
            'qtest_random_banners',
        ],
    };
}

sub qtest_random_banners :QTEST {
    my ($proj) = @_;
    my $cc = $proj->phrase_list->random_banners(1000)->count;
    return {
        status => ($cc <= 1000  and  $cc >= 950)  ? 'Ok' : 'Error',   # random_banners может вернуть баннеры, которых нет в таблице - из-за возможных расхождений между базой бендера и дин-таблицей banners_extended
        description => "cc: $cc",
    };
}

sub qtest_bender :QTEST {
    my ($proj) = @_;

    my $cc_query = 10000;
    my $phr = $proj->phrase("купить слона");  # 2017-05-10: Найдено 258 баннеров
    # for i in 01i 02i 01h 02h; do perl -I /opt/broadmatching/scripts/lib/ -we 'use Utils::Common;  my $host = "bmbender-front'$i'.yandex.ru";  $Utils::Common::options->{DistrBannersBender_params}{hosts} = [$host];  use Project; my $proj = Project->new({});  my $cc = $proj->banners_bender->find_ids_raw("купить слон", 1000); print "$host cc: $cc\n"' ; done 2>/dev/null     bmbender-front01i.yandex.ru cc: 61    bmbender-front02i.yandex.ru cc: 67    bmbender-front01h.yandex.ru cc: 71    bmbender-front02h.yandex.ru cc: 59

    my $time = time;
    # Можно использовать do_safely и timeout, но нужно учесть, что bender делает несколько попыток обращения к хостам, обернутых в eval, и alarm может быть перехвачен тем eval'ом
    my @bids = $proj->banners_bender->find_ids($phr, $cc_query);
    my $cc_found = @bids;
    my $duration = time - $time;
    return {
        status => ($cc_found <= $cc_query  and  $cc_found > 0  and  $duration <= 5 )  ? 'Ok' : 'Error',   # random_banners может вернуть баннеры, которых нет в таблице - из-за возможных расхождений между базой бендера и дин-таблицей banners_extended
        description => "cc_found: $cc_found duration: $duration",
    };
}

sub qtest_base_normalization :QTEST {
    my ($proj) = @_;
    my $cc = $proj->phrase_list(['маленький холодильник', 'маленькие холодильники'])->pack_list->count;
    return {
        status => $cc == 1 ? 'Ok' : 'Error',
        description => "cc: $cc",
    };
}

sub qtest_base_synonyms :QTEST {
    my ($proj) = @_;
    my $cc = $proj->phrase_list(['samsung', 'самсунг'])->snorm_pack_list->count;
    return {
        status => $cc == 1 ? 'Ok' : 'Error',
        description => "cc: $cc",
    };
}

sub qtest_cdict_search_count :QTEST {
    my ($proj) = @_;
    my $cc = $proj->phrase('купить')->get_search_count;
    return {
        status => $cc > 10_000_000 ? 'Ok' : 'Error',
        description => "cc: $cc",
    };
}

sub qtest_cdict_search_count_reg :QTEST {
    my ($proj) = @_;
    my $cc = $proj->phrase('Холодильник')->get_search_count([ 213 ]); # Москва
    return {
        status => $cc > 100_000 ? 'Ok' : 'Error',
        description => "cc: $cc",
    };
}

sub qtest_cdict_search_query_count :QTEST {
    my ($proj) = @_;
    my $cc = $proj->phrase('вконтакте')->get_search_query_count;
    return {
        status => $cc > 10_000_000 ? 'Ok' : 'Error',
        description => "cc: $cc",
    };
}

sub qtest_comma_bug : QTEST {
    my $proj = shift;
    my $pi = 3.1415;
    my $pi_str = " $pi ";
    return {
        status      => $pi_str =~ /,/ ? 'Error' : 'Ok',
        description => "pi: $pi_str",
    };
}

sub qtest_utils_filter : QTEST {
    my $proj = shift;
    my $array = [
           {v1=>1,v2=>1},
           {v1=>2,v2=>'aaa'},
           {v1=>3,v2=>'bbb'},
           {v1=>4,v2=>18},
           {v1=>5,v2=>19},
           {v1=>6,v2=>"ccc'ccc"},
    ];
    my $error_text = "";
    my $array2 = $proj->filter( { filter => { "v1 >" => 1, "v2 like" => "b" } } )->filter($array);
    $error_text .= "Error in <=> and LIKE," if scalar(@$array2) != 1;

    my $array3 = $proj->filter( { filter => { "v1" => [1,4,8,9] } } )->filter($array);
    $error_text .= "Error in Element in [ Array ]," if scalar(@$array3) != 2;

    my $array4 = $proj->filter( { filter => { "v2" => "aaa" } } )->filter($array);
    $error_text .= "Error in Search One Text Element," if scalar(@$array4) != 1;

    my $array5 = $proj->filter( { filter => { "v2" => "KKK" } } )->filter($array);
    $error_text .= "Error in Search No Element," if scalar(@$array5) != 0;

    my $array6 = $proj->filter( { filter => { "v2" => [ 'aaa', 'bbb', "ccc'ccc" ] } } )->filter($array);
    $error_text .= "Error in Search Text Elements in Array," if scalar(@$array6) != 3;

    chop($error_text) if $error_text;

    return {
        status      => $error_text ? 'Error' : 'Ok',
        description => $error_text ? $error_text : "All Ok",
    };
}

sub qtest_matrixnet : QTEST {
    my $proj = shift;
    eval {
        my $preboot_sigpipe = $SIG{PIPE}; #See BSDEV-61728
        require Matrixnet; #See BSDEV-61728
        $SIG{PIPE} = $preboot_sigpipe;
    };
    return {
        status => $@ ? 'Error' : 'OK',
        description => $@ ? $! : 'All OK',
    };
}

sub qtest_dssm : QTEST {
    my $proj = shift;
    eval {
        my $preboot_sigpipe = $SIG{PIPE}; #See BSDEV-61728
        require DSSM; #See BSDEV-61728
        $SIG{PIPE} = $preboot_sigpipe;
    };
    return {
        status => $@ ? 'Error' : 'OK',
        description => $@ ? $! : 'All OK',
    };
}

sub qtest_zora : QTEST {
    my $proj = shift;

    my $df = 0;
    my $l = 0;
    eval {
        my $page = BM::Pages::Page->new({
            proj => $proj,
            url => "www.yandex.ru",
            no_cache => 1,
            timeout => 3,
            zora => 1,
        });
        my $text = $page->tt;
        $df = $page->{download_failed};
        $l = length($text);
    };
    my $err = $@;
    my $is_error = $err || $df || !$l;
    if ($is_error) {
        $proj->log("err: $err");
        $proj->log("df: $df");
        $proj->log("l: $l");
    }

    return {
        status => $is_error ? 'Error' : 'OK',
        description => $is_error ? $! : "All OK",
    };
}

sub qtest_unittest_broad_kyoto : QTEST {
    my $proj = shift;

    my $kyoto_unittest = $proj->options->{scripts} . '/tests/broad_kyoto/test_more.pl > /dev/null 2> /dev/null';

    my $is_error = system($kyoto_unittest);

    return {
        status => $is_error ? 'Error' : 'OK',
        description => $is_error ? "some unittests for kyoto failed (check output of 'scripts/tests/broad_kyoto/test_more.pl')" : "All OK",
    };
}

sub qtest_broad_kyoto : QTEST {
    my $proj = shift;

    my $broad_kyoto = $proj->broad_kyoto();

    my $key = 'qtest_broad_kyoto_key' . int(10000 * rand());
    my $value = 42;
    my $is_error = 0;
    my $set_result = $broad_kyoto->set($key, $value, 60);
    $is_error = 1 if !$set_result;
    my $get_result = $broad_kyoto->get($key);
    $is_error = 1 if $get_result != $value;
    my $delete_result = $broad_kyoto->delete($key);
    $is_error = 1 if !$delete_result;

    return {
        status => $is_error ? 'Error' : 'OK',
        description => $is_error ? "set value=$value, set result=$set_result, get result=$get_result, delete result=$delete_result" : "All OK",
    };
}

sub qtest_banners : QTEST {
    my $proj = shift;

    my @errors;

    my %bid2title = (
        4 => 'Это теcт!!!',
        2765751036 => 'Матрас Удобный',
    );

    { # ids2bnl
        my $bnl = $proj->bf->ids2bnl([keys %bid2title]);
        unless (scalar @$bnl == scalar keys %bid2title) {
            push @errors, "Bad count. Seen bids: ".join(",", map {my $bnr = $_; $bnr->id} @$bnl)
        }
        my @bad;
        push @bad, map {my $bnr = $_; $bnr->id} grep {my $bnr = $_; $bid2title{$bnr->id} ne $bnr->title} @$bnl;
        push @errors, "bad: @bad" if @bad;
    }

    return {
        status => @errors ? 'Error' : 'OK',
        description => @errors ? join("; ", @errors) : "All OK",
    };
}

# Проверяем, не сломан ли $SIG{PIPE} - см.  https://st.yandex-team.ru/BSDEV-61728
sub qtest_sigpipe : QTEST {
    my $proj = shift;

    my @errors;

    # Нужен достаточно большой текстовый файл (подбираем эмпирически)
    my $file = $Utils::Common::options->{dirs}{dicts} . "/dict_zaliznyak_stat";
    unless (-f $file) {
        die "File ($file) does not exist!";
    }
    my $min_file_bytes = 42 * 1024 * 1024;
    my $file_bytes = file_bytes($file);
    if ($file_bytes < $min_file_bytes) {
        push @errors, "File ($file) is too small ($file_bytes < $min_file_bytes)" ;
    }

    my $cmd = "timeout --kill-after 1 3 tac $file | head -n1";
    $proj->log("cmd: $cmd");

    my $start_time = time;
    my $res = system("$cmd");
    if ($res) {
        push @errors, "Error in cmd { $cmd }: $res $? ($!)";
    }
    my $duration = time - $start_time;

    if ($duration > 1) {
        push @errors, "duration: $duration";
    }

    open my $fh, "cat /proc/self/status |";
    my ($mask) = map{m!SigIgn:	(\d+)! ? ($1) : ()} $fh->getlines();
    push @errors, "Incorrect signal mask: $mask" if $mask !~ m!^0+[06]$!; #ToDo: Who sets IGN to SIGINT and SIGQUIT?

    return {
        status => @errors ? 'Error' : 'OK',
        description => @errors ? join("; ", @errors) : "All OK",
    };
}

sub run_qtest {
    my ($proj, $q) = @_;
    no strict 'refs';
    $q->($proj);
}

1;
