=encoding UTF-8

=cut

=head1 Название

States - Работа со статусами

=head1 Описание

Базовый класс: L<ObjLib::ProjPart>

Нужно проинициализировать нужным current_type, чтобы нормально работало

Для каждого типа статусов нужно создавать свой объект, указывая тип через current_type.

Документация по языку описания состояний и действий: L<States_texts>.

=cut

# взято отсюда:
# https://svn.yandex.ru/partner/trunk/lib/States.pm

package States;

use std;

use base qw(ObjLib::ProjPart);

=head1 Инициализация

=head2 init 

=cut

sub init {
    my $self = shift;
    
    my $state_text_package = 'States_texts::' . $self->{'current_type'};
    (eval "require $state_text_package")
        ? $self->all_states_texts({$self->{'current_type'} => eval "\$${state_text_package}::STATES_TEXTS"})
        : die "Cannot find package \"$state_text_package\"";        
}

########################################################
#Статические переменные класса
########################################################

#Чтобы не парсить каждый раз, парсим только один раз
my $states_array = {}; #Тип статусов => [ статус, действие, статус ]
my $states_hash  = {}; #Тип статусов => статус => действие => статус
my $actions_hash = {}; #Тип статусов => действие => [ статус, статус ]

=head1 Ацессоры

=head2 all_states_texts 

Скаляр с огромным текстом из переменной $STATES_TEXTS в файле lib/States_texts/$current_type.pm

=cut

sub all_states_texts {
    my $self = shift;
    if(@_){$self->{'all_states_texts'} = shift;}
    return $self->{'all_states_texts'};
}

=head2 current_type 

Текущий тип статусов

=cut

sub current_type {
    my $self = shift;
    if(@_){$self->{'current_type'} = shift;}
    return $self->{'current_type'};
}

=head1 Вспомогательные методы

=head2 states_array2hash 

B<Параметры:>

B<Возвращаемое значение:>

преобразует массив троек в хеш 'статус => { действие => статус }'

=cut

sub states_array2hash {
    my $self = shift;
    my $array = shift;
    my $h = {};
    $h->{$_->[0]}->{$_->[1]} = $_->[2] for @$array;
    return $h;
}

=head2 states_array2actionshash

B<Параметры:>

B<Возвращаемое значение:>

преобразует массив троек в хеш массивов 'действие => [ статус, статус ]'

=cut

sub states_array2actionshash {
    my $self = shift;
    my $array = shift;
    my $h = {};
    for( @$array ){
        $h->{$_->[1]} = [] unless $h->{$_->[1]};
        push @{$h->{$_->[1]}}, [$_->[0] => $_->[2]];
    }
    return $h;
}

=head2 array_copy 

B<Параметры:>

B<Возвращаемое значение:>

Копируем массив

=cut

sub array_copy {
    my ($self,$array) = @_;
    return unless ref($array) eq 'ARRAY';
    return [@$array];
}

=head2 array_copy_pref 

B<Параметры:>

B<Возвращаемое значение:>

Копируем массив, добавляя префикс

=cut

sub array_copy_pref {
    my ($self,$pref,$array) = @_;
    return unless ref($array) eq 'ARRAY';
    return [ map { [ $pref.$_->[0], $_->[1], $pref.$_->[2] ]  } @$array];
}

=head2 states_text2array 

B<Параметры:> 1) скаляр с текстом, который описывает статусы

B<Возвращаемое значение:> 1) Массив массивов

Большая и умная саба, которая преобразует текст из переменной $STATES_TEXTS в файле lib/States_texts/$current_type.pm
в массив троек [состояние,действие,состояние]

    my $states =  States->new( { 'proj' => $proj, current_type=>'U', rights => $rights } );
    LogDump $states->states_text2array($states->all_states_texts->{"U"});

    $VAR1 = [
              [     
                'FINANCIER_BEG_1',
                'status_financier',
                'FINANCIER_BEG_1'
              ],    
              [     
                'FINANCIER_STOP_1',
                'status_financier',
                'FINANCIER_STOP_1'
              ],    
    ...
    ];

=cut

sub states_text2array {
    my $self = shift;
    my $text = shift;
    my $dont_copy_link = shift || {}; #Хеш статусов, не порождающих связи при генерации блоков по событию (WORK   archive  ARCH)
    my $recursive = shift;  # вызывается рекурсивно для вложенных блоков

    my @lines = split("\r?\n",$text);
    
    my $n = 0;
    
    # хэш { $prefix => [ [$old,$act,$new],... ] }
    # действия для блоков, заданных в фигурных скобках, вида
    #   WORK {
    #       1   begin_match  2 
    #   }
    # добавляются в префикс 'WORK'
    # по-элементные действия
    #   WORK_1  begin_match     WORK_2
    # добавляются в префикс ''
    my $blocks   = {};
    
    my $blocklines  = []; #Связи между блоками состояний
    
    my $curblock = '';  # внешний блок, всегда пустая строка!!

    my $block_name  = ''; #название вложенных блоков
    my $block_text  = ''; #Текст вложенных блоков
    my $block_count = 0; #Счётчик более глубоких вложений
    
    for(@lines){
        $n++;
    
        s/#.*$//; #Удаляем комментарии
        next if m/^\s*$/; #Выкидываем пустые строки
    
        s/^\s*//; #Удаляяем начальные и конечные пробелы
        s/\s*$//;
    
        my @els = split /\s+/, $_; #Дробим строку на элементы

        if($block_name){#Если был начат блок
            if($els[1] && $els[1] eq '{'){
                $block_count++;
            }elsif($els[0] eq '}'){ #Закрываем блок
                $block_count--;
            }

            if($block_count<0){ #Закрываем текст текущего блока
                my $new_list = $self->states_text2array($block_text,$dont_copy_link,1); #Получаем данные блока
                $blocks->{$block_name} = [] unless $blocks->{$block_name};
                push(@{$blocks->{$block_name}}, @$new_list);
                $block_name  = '';
                $block_text  = '';
                $block_count = 0;
            }else{
                $block_text .= join(' ',@els)."\n";
            }
 
        }elsif($els[1] eq '{'){
            #Начало блока
            $block_name = $els[0].'_';
    
        }elsif(@els == 2){
    
            #Взорвать блок - уничтожает все внутренние связи в блоке
            if($els[0] eq '>>explode'){
                $blocks->{$els[1].'_'} = []; #Очищаем массив связей
            }
            #Уничножить блок (содержимое и связи)
            elsif($els[0] eq '>>clean'){
                if(exists($blocks->{$els[1].'_'})) {
                    $blocks->{$els[1].'_'} = []; #Очищаем массив связей
                    $blocklines = [ grep($_->[0] !~ /^$els[1]_/ && $_->[2] !~ /^$els[1]_/, @{$blocklines}) ];
                } else {
                    # перебераем возможные ключи
                    my $offset = 0;
                    my $index = index($els[1], '_', $offset);
                    while($index >= 0) {
                        my $key = substr($els[1], 0, $index);
                        my $subkey = substr($els[1], $index+1);

                        $offset = $index+1;
                        $index = index($els[1], '_', $offset);

                        # есть ли такой блок?
                        if(exists($blocks->{$key.'_'})) {
                            my $new_arr = [ grep($_->[0] !~ /^$subkey/ && $_->[2] !~ /^$subkey/, @{$blocks->{$key.'_'}}) ];
                            # есть ли у этого блока искомые вложенные?
                            if(scalar(@$new_arr) != scalar(@{$blocks->{$key.'_'}})) {
                                $blocks->{$key.'_'} = $new_arr;
                                $blocklines = [ grep($_->[0] !~ /^${key}_${subkey}/ && $_->[2] !~ /^${key}_${subkey}/, @{$blocklines}) ];
                                last;
                            }
                        }
                    }
                }
            }
            elsif($els[0] eq '>>explode_without_status'){
                #LogDump($blocks->{$els[1].'_'});
                $blocks->{$els[1].'_'} = [ grep { $_->[1]=~/status/ } @{$blocks->{$els[1].'_'}} ]; #Очищаем массив связей
            }
            elsif($els[0] eq '>>dont_copy_link'){
                $dont_copy_link->{$els[1]} = 1;
            }
            else{
                die("Unknown directive: [$els[0] $els[1]]");
            }
    
        }elsif(@els == 3){
    
            #Если обычные элементы
            if( $els[0] =~ m/\d+$/ && $els[2] =~ m/\d+$/){
                push @{$blocks->{$curblock}}, \@els;
    
            #Копирование блока
            }elsif($els[0] eq '>>copy'){
                $blocks->{$curblock.$els[2].'_'} = $self->array_copy($blocks->{$els[1].'_'}); #Копируем массив
            }elsif($els[0] eq '>>add'){
                $blocks->{$curblock.$els[2].'_'} = [
                    @{$blocks->{$curblock.$els[2].'_'}}, 
                    @{$self->array_copy($blocks->{$els[1].'_'})}
                    ]; #Копируем массив
            }elsif($els[0] eq '>>deleteaction'){
                $blocks->{$curblock.$els[1].'_'} = [ grep { $_->[1] ne $els[2] } @{$blocks->{$curblock.$els[1].'_'}} ]; #
    
            #Если порождение из одного блока другого
            }elsif($els[0] !~ m/\d+$/ && $els[2] !~ m/\d+$/){
            
                my $actions = [$els[1]];

                $blocks->{$els[2].'_'} = $self->array_copy($blocks->{$els[0].'_'}); #Копируем массив
                #Получаем список всех возможных состояний
                my %h = ();
                for my $e (@{$blocks->{$els[0].'_'}}){
                    $h{$e->[0]}++;
                    $h{$e->[2]}++;
                }
                
                foreach my $action (@$actions) {
                    for(keys %h){
                        if($curblock){
                            push @{$blocks->{$curblock}}, [$els[0].'_'.$_, $action, $els[2].'_'.$_];
                        }else{
                            /(^|\D)(\d+)$/;
                            next if $2 && $dont_copy_link->{$2} && $action !~ /^status_/;
                            push @$blocklines, [$els[0].'_'.$_, $action, $els[2].'_'.$_];
                        }
                    }
                }
            }elsif($els[0] !~ m/\d+$/ && $els[2] =~ m/\d+$/){
                my @arr = keys %{{ map {$_=>1} map { $_->[0], $_->[2] } @{$blocks->{$curblock.$els[0].'_'}} }};
                push( @{ $blocks->{ $curblock } },  
                        map { [ $els[0].'_'.$_, $els[1], $els[2] ] } @arr
                    ); 
            }else{
                die("Unknown directive: [$els[0] $els[1] $els[2]]");
            }
        } else {
            die "Wrong line: @els\n";
        }
    }
    
    my $outlines = []; #Массив выходных строк
    
    #Получаем все возможные переходы
    for my $b (keys %$blocks){
        for my $el (@{$blocks->{$b}}){
            push @$outlines, [ $b.$el->[0] , $el->[1], $b.$el->[2] ];
        }
    }
    
    push @$outlines, @$blocklines;
    
    return $outlines;
}

=head2 get_array 

B<Параметры:> -

B<Возвращаемое значение:> Массив массивов

Возвращает данные обо всех статусах_до - действиях - статусах_после текущего current_type

    LogDump $states->get_array;
    $VAR1 = [ 
              [ 
                'BEG_1',
                'add_inf',
                'BEG_3'
              ],
              [ 
                'BEG_1',
                'right_ShowTrivialMenu',
                'BEG_1'
              ],
    ...
    ];

=cut

sub get_array {
    my ($self) = @_;
    my $type = $self->current_type;
    $states_array->{$type} = $self->states_text2array($self->all_states_texts->{$type}) unless $states_array->{$type};
    return $states_array->{$type};
}

=head2 get_states_hash

B<Параметры:> - 

B<Возвращаемое значение:> хеш хешей статусов указанного типа

    LogDump $camp_states->get_states_hash;
    $VAR1 = {
              'YANDEXMANAGER_BLACK_31' => { 
                                          'add_inf' => 'YANDEXMANAGER_BLACK_33',
                                          'status_stale' => 'YANDEXMANAGER_BLACK_31'
                                        },   
              'YANDEXMANAGER_STOP_31' => { 
                                         'status_stop' => 'YANDEXMANAGER_STOP_31',
                                         'add_inf' => 'YANDEXMANAGER_STOP_33',
                                         'blacklist' => 'YANDEXMANAGER_BLACK_31',
                                         'start' => 'YANDEXMANAGER_BEG_31',
                                         'status_stale' => 'YANDEXMANAGER_STOP_31'
                                       }, 
    ...
            };

=cut

sub get_states_hash {
    my ($self) = @_;
    my $type = $self->current_type;
    $states_hash->{$type} = $self->states_array2hash($self->get_array) unless $states_hash->{$type};
    return $states_hash->{$type};
}

=head2 get_actions_hash

B<Параметры:> - 

B<Возвращаемое значение:> 1) хеш действий текущего типа (current_type)

    LogDump $states->get_actions_hash;
    $VAR1 = {
          'right_AdmViewNoticeTpl' => [
                                        [     
                                          'ADMIN_BEG_1',
                                          'ADMIN_BEG_1'
                                        ]     
                                      ],    
          'right_ViewCampaignCategoryDistr' => [
                                                 [     
                                                   'ADMIN_BEG_1',
                                                   'ADMIN_BEG_1'
                                                 ],
    ...
                                               ]
    ...
    };                           


=cut

sub get_actions_hash {
    my ($self) = @_;
    my $type = $self->current_type;
    $actions_hash->{$type} = $self->states_array2actionshash($self->get_array) unless $actions_hash->{$type};
    return $actions_hash->{$type};
}

=head2 actionsline2hash 

B<Параметры:> 1) скаляр со строкой

B<Возвращаемое значение:> 1) ссылка на хеш

    LogDump $states->actionsline2hash('aaa+bbb-ccc');
    $VAR1 = {
          'bbb' => 1,
          'aaa' => 1,
          'ccc' => 0
        };

=cut

sub actionsline2hash {
    my ($self, $line) = @_;
    my $h = {};
    $line = '+'.$line unless $line =~ /^[-+]/; #приводим к одному виду
    while( $line =~ s/([-+])([A-Za-z0-9_]+)// ){
        $h->{$2} = $1 eq '+' ? 1 : 0;
    }
    return $h;
}

=head2 check_actions 

B<Параметры:>

B<Возвращаемое значение:>

Проверяет наличие или отсутствия ключей по указанному хешу

=cut

sub check_actions {
    my ($self, $h, $hf) = @_;
    for my $k ( keys %$hf ){
        my $e = (defined($h->{$k})  && $h->{$k}) ? 1 : 0; #Существование такого действия
        return 0 if $hf->{$k} != $e;  #Если реальность не совпадает с требованиями
    }
    return 1;
}

########################################################
#Методы
########################################################

=head1 Методы 

=head2 get_states_by_action 

B<Параметры:> 1) скаляр с действием

B<Возвращаемое значение:> 1) массив массивов со статусами

Возвращает пары статусов которые работают с указанным действием
(статус до действия и статус после действия)

    LogDump $states->get_states_by_action('get_partner_id');
    $VAR1 = [
              [
                'YANDEXMANAGER_BEG_2',
                'YANDEXMANAGER_BEG_3'
              ],
              [
                'YANDEXMANAGER_BEG_22',
                'YANDEXMANAGER_BEG_33'
              ],
    ...
    ]

=cut

sub get_states_by_action {
    my ($self, $action) = @_;
    return $self->get_actions_hash->{$action};
}

=head2 get_states_by_action_in

B<Параметры:> 1) скаляр с действием

B<Возвращаемое значение:> 1) ссылка на массив со статусами, в которые попадаешь по указанному действию

=cut

sub get_states_by_action_in {
    my ($self, $action) = @_;
    return [ map { $_->[1] } @{$self->get_actions_hash->{$action}} ]; #оставляем только исходящие статусы
}

=head2 get_states_by_action_out

B<Параметры:> 1) скаляр с действием

B<Возвращаемое значение:> 1) ссылка на массив со статусами, из которых возможны переходы по указанному действию

=cut

sub get_states_by_action_out {
    my ($self, $action) = @_;
    return [ map { $_->[0] } @{$self->get_actions_hash->{$action}} ]; #оставляем только исходящие статусы
}

=head2 get_actions

B<Параметры:> 1) скаляр со статусом

B<Возвращаемое значение:> 1) список действий по статусу

    LogDump $states->get_actions("BEG_1");
    $VAR1 = {
              'right_EditCampaigns' => 'BEG_1',
              'right_Campaign_bmformat_View' => 'BEG_1',
              'make_distr' => 'DISTRPARTNER_1',
              'right_ViewPartnerTools' => 'BEG_1',
    ...
    }

=cut

sub get_actions {
    my ($self, $obj_state) = @_;
    return {} unless defined $obj_state;
    return $self->get_states_hash->{$obj_state};
}

=head2 compile_act_line 

B<Параметры:> 1) скаляр со строкой

B<Возвращаемое значение:> 1) ссылка на массив хешей

Полученная строка разрезается по \s и каждый элемент обрабатывается сабой actionsline2hash

    LogDump $states->compile_act_line("aaa+bbb -ccc");
    $VAR1 = [
              {
                'bbb' => 1,
                'aaa' => 1
              },
              {
                'ccc' => 0
              }
            ];

=cut

sub compile_act_line {
    my ($self, $act_line) = @_;
    return [map{ $self->actionsline2hash($_) } grep {$_} split(/\s/, $act_line)]
}

=head2 check_state_against_filter 

B<Параметры:>

B<Возвращаемое значение:>

=cut

sub check_state_against_filter {
    my ($self, $state, $filter) = @_;
    $filter = $self->compile_act_line($filter) unless ref $filter eq 'ARRAY';
    
    my $states = $self->get_states_hash;
    for my $g (@$filter) { #Перебираем группы
        return 1 if $self->check_actions($states->{$state}, $g) #Если вошло хоть в одну из групп
    }
    return 0
}

=head2 get_states_by_actions_line

B<Параметры:> 1) скаляр со строкой типа "aaa+bbb-ddd bbb+eee fff-rrr", где перечислены действия

B<Возвращаемое значение:>

Возвращает массив статусов по действиям (объединяемым или вычитаемым), перечисленным в строке
 aaa+bbb-ddd bbb+eee fff-rrr

=cut

sub get_states_by_actions_line {
    my ($self, $act_line) = @_;
    #Выделяем массив групп, которые нужно включить
    my $filter = $self->compile_act_line($act_line);
    my $states = $self->get_states_hash;
    
    my @result;
    foreach (keys %$states) { #Перебираем статусы
        push(@result, $_) if $self->check_state_against_filter($_, $filter)
    }
    return \@result;
}

=cut

=head2 list_avaliable_states

B<Параметры:> -

B<Возвращаемое значение:> 1) % ключ - имя статуса, значение - порядковый номер (нумерация с 1)

=cut

sub list_avaliable_states {

    my $base_path = $INC{'States.pm'};
    $base_path =~ s/\/lib(\/)+[^\/]+$//;

    my @files = `ls $base_path/lib/States_texts/*.pm`;

    my $i; 
    my %h; 

    foreach (@files) {
        $i++;
        m{([^/.]*)\.pm$};
        $h{$1} = $i; 
    }

    return %h; 
}

1;
