package StaticMap;

use 5.008;
use strict;
use warnings;
use Digest::MD5;
use File::Copy;
use Fcntl qw/:flock/;

require DynaLoader;

# Подключаем собранную so-шку по абсолютному пути
use Cwd "abs_path";
push @DynaLoader::dl_library_path, abs_path(__FILE__ . "/../Utils/StaticMap");

our @ISA = qw(DynaLoader);
our $VERSION = '0.01';

bootstrap StaticMap $VERSION;

sub _get_work_file {
    my $file = shift;
    my %options = @_;

    return $options{'id'} ?
           Digest::MD5::md5_hex("$file\tid=$options{'id'}") :
           Digest::MD5::md5_hex($file);
}

sub build {
    my $file = shift;
    my %options = @_;

    my $work_dir = $Utils::Common::options->{'static_map_params'}{'work_dir'};
    my $temp_dir = $Utils::Common::options->{'static_map_params'}{'temp_dir'};
    my $work_file = "$work_dir/" . _get_work_file($file, %options);
    my $lock_file = "$temp_dir/" . Digest::MD5::md5_hex($work_file) . '.lock';
    my $silent = 1;

    open(my $lock_fh, '>', $lock_file) or die("File: $lock_file $!");
    flock($lock_fh, LOCK_EX) or die($!);

    if (-e $work_file && (stat $file)[9] < (stat $work_file)[9]) {
        my $static_map = StaticMap->new($work_file);
        flock($lock_fh, LOCK_UN) or die($!);
        return $static_map;
    }

    my $transformed_file = Utils::Sys::get_tempfile('', DIR => $temp_dir, UNLINK => 1);
    if ($options{'transform_function'}) {
        $options{'transform_function'}->($file, $transformed_file);
    } else {
        $transformed_file = $file;
    }
    my $temp_file = Utils::Sys::get_tempfile('', DIR => $temp_dir, UNLINK => 1);
    Utils::Sys::do_sys_cmd("LC_ALL=C sort -T $temp_dir $transformed_file -o $temp_file", silent => $silent);
    File::Copy::move($temp_file, $work_file) or die("Can't move file: $temp_file -> $work_file => $!");
    chmod(0644, $work_file) or die($!);
    unlink($transformed_file) or die($!) if $options{'transform_function'};
    my $static_map = StaticMap->new($work_file);
    flock($lock_fh, LOCK_UN) or die($!);

    return $static_map;
}

1;
