package Utils::CommonPatches;

use strict;
use warnings;
use utf8;

use HTTP::Response;
use Utils::LightCommon;
use Utils::Hosts;

my $dirs = $Utils::LightCommon::dirs;

my $BM_MDB_PREPROD_HOSTS = ['c-mdbhgc7guhanojqnv0m7.rw.db.yandex.net', 'sas-fihvr8nc09p544mo.db.yandex.net', 'vla-71n287wtpnb2z28f.db.yandex.net'];
my $BM_MDB_TEST_HOSTS = ['c-mdb37gho2fulj0m9fii9.rw.db.yandex.net', 'sas-ab02gtlwh9lwifwq.db.yandex.net', 'vla-njvm1g6u9lpinbq7.db.yandex.net'];

my $BM_MDB_PREPROD_PASSPATH = $dirs->{secrets}. "/passwords/mysql-preprod-mdb_password";
my $BM_MDB_TEST_PASSPATH = $dirs->{secrets}. "/passwords/mysql-test-mdb_password";


# $patch_options: { название_патча => хэш_настроек }
# патч накладывается рекурсивным проходом по хешу, если нужно заменить какую-то ветвь целиком - допишите '#{strict}' к имени ключа

# Для использования нужно создать в директории broadmatching файл 'patchfile', в котором перечислить названия используемых патчей
# Например:
#   emurav@catalogia-media-dev01e:~/arcadia/rt-research/broadmatching$ cat patchfile
#   debug_env
#
# Или можно указать список патчей в переменной среды:
#   BM_USE_PATCH=debug_env ./my_script.pl
#   BM_USE_PATCH=one_patch,another_patch,third_patch ./my_script.pl
#
# Если у вас в patchfile указан какой-то патч, но вы хотите запустить программу без него, то это можно сделать так:
#   BM_NO_PATCH=patch_to_exclude ./my_script.pl
#
# Поддерживается пробрасывание кастомных патчей напрямую через переменную среды, например:
#   BM_PATCH_STR='global_params/RANDOM_CTR_COEF:2;RedButton_params/log_table:TestTable' ./my_script.pl
#


our $patch_options = {

    # подробнее про этот патч: https://wiki.yandex-team.ru/BM/Debug-Env
    'debug_env' => {

        # перенаправляем mysql-соединения в тестовую базу
        catalogia_media_db_inf => { hosts => $BM_MDB_TEST_HOSTS, password_path=>$BM_MDB_TEST_PASSPATH},
        catalogia_media_repl_db_inf => {hosts => $BM_MDB_TEST_HOSTS, password_path=>$BM_MDB_TEST_PASSPATH},
        bannerland_db_inf => { hosts => $BM_MDB_TEST_HOSTS, password_path=>$BM_MDB_TEST_PASSPATH},
        monitoring_db_inf => { hosts => $BM_MDB_TEST_HOSTS, password_path=>$BM_MDB_TEST_PASSPATH},

        # отключаем отправку писем
        mails_debug_mode => 1,

        # mock'аем http-запросы
        # формат: [ регулярка => ответ, который будет получен на урлы, которые на неё матчатся, или undef, если запрос надо послать как есть ]
        # если урл не матчится ни на одну, запрос будет задан как обычно
        UserAgent_params => {
            mock_post_requests => [
                # yabs-хендлеры для dynsmart
                [ '/export/set_performance_phrases.pl' => HTTP::Response->new(200, "Mock response", undef, "ok") ],
                [ '/export/set_bmatch_dynamic_phrases.pl' => HTTP::Response->new(200, "Mock response", undef, "ok") ],

                # ручки директа для dynsmart
                [ '/jsonrpc/Mirrors' =>  HTTP::Response->new(200, "Mock response", undef, '{"jsonrpc":"2.0","id":null,"result":["mock_domain.com"]}')],
                [ '/performanceModerate' => HTTP::Response->new(200, "Mock response", undef, '{"result":[{"Status":"Accept"}]}') ],

                # разрешаем POST-запросы к тестовой катмедии
                [ 'catalogia-media-dev02e\.yandex\.ru' => undef ],

                # разрешаем POST-запросы к http://bsfastexport.yandex.ru/ так как это определенно чтение
                [ 'http://bsfastexport\.yandex\.ru/' => undef ],

                [ 'yabs-id-generator' => undef ],

                # catch-all: отключаем любые другие POST-запросы
                [ '.' => HTTP::Response->new(200, "Mock response", undef, "Default mock response for post requests") ],
            ],

            mock_get_requests => [
                # если нужно отключить и любые GET-запросы тоже:
                # [ '.' => HTTP::Response->new(200, "Mock response", undef, "Default mock response for get requests") ],
            ],
        },

        # отключаем запись кэша категорий
        CategoriesTree_params => {
            never_write_categs_cache => 1,
        },

        # отключаем отправку метрик в графит
        GraphiteClient_params => {
            debug_mode => 1,
        },

        SolomonClient_params => {
            agent_port => 10060,
        },

        # отключаем заливку в SB
        sandbox_params => {
            debug_mode => 1,
        },

        # уводим запись в kyotocache в отдельное пространство имён
        kyoto => {
            salt => "debug_env_salt_" . time() . "_" . $$,
        },

        # отключаем защиту от запуска на "неправильных" хостах
        override_assert_curr_host => 1,

        # включаем в разных местах уведомления о тестовом режиме
        show_debug_mode_warnings => 1,
    },

    'mdb_test_mysql' => {
        catalogia_media_db_inf      => { hosts => $BM_MDB_TEST_HOSTS, password_path => $BM_MDB_TEST_PASSPATH },
        catalogia_media_repl_db_inf => { hosts => $BM_MDB_TEST_HOSTS, password_path => $BM_MDB_TEST_PASSPATH },
        bannerland_db_inf           => { hosts => $BM_MDB_TEST_HOSTS, password_path => $BM_MDB_TEST_PASSPATH },
        monitoring_db_inf           => { hosts => $BM_MDB_TEST_HOSTS, password_path => $BM_MDB_TEST_PASSPATH },
    },

    'mdb_preprod_mysql' => {
        catalogia_media_db_inf      => { hosts => $BM_MDB_PREPROD_HOSTS, password_path => $BM_MDB_PREPROD_PASSPATH },
        catalogia_media_repl_db_inf => { hosts => $BM_MDB_PREPROD_HOSTS, password_path => $BM_MDB_PREPROD_PASSPATH },
        bannerland_db_inf           => { hosts => $BM_MDB_PREPROD_HOSTS, password_path => $BM_MDB_PREPROD_PASSPATH },
        monitoring_db_inf           => { hosts => $BM_MDB_PREPROD_HOSTS, password_path => $BM_MDB_PREPROD_PASSPATH },
    },
    
    'mysql_from_env' => ($ENV{MYSQL_HOST} ? {
        catalogia_media_db_inf => { hosts=>$ENV{MYSQL_HOST}, port => $ENV{MYSQL_PORT}, pass=>$ENV{MYSQL_PASSWORD} },
        catalogia_media_repl_db_inf => { hosts=>$ENV{MYSQL_HOST}, port => $ENV{MYSQL_PORT}, pass=>$ENV{MYSQL_PASSWORD} },
        bannerland_db_inf => { hosts=>$ENV{MYSQL_HOST}, port => $ENV{MYSQL_PORT}, pass=>$ENV{MYSQL_PASSWORD} },
        monitoring_db_inf => { hosts=>$ENV{MYSQL_HOST}, port => $ENV{MYSQL_PORT}, pass=>$ENV{MYSQL_PASSWORD} },
    } : {}) ,

    'no_mysql' => {
        # перенаправляем mysql-соединения в никуда
        # (для тестирования скриптов, которые должны работать без доступа к mysql)
        catalogia_media_db_inf => undef,
        catalogia_media_repl_db_inf => undef,
        bannerland_db_inf => undef,
    },
    'rekub_beta' => {
        PrefProjSrv_params => {
            port                => 20204,
            num_forks           => 3,
            min_free_forks      => 1,
        },
    },
    'debug_dt_proxy' => {
        dt_proxy_params => {
            proxy_port => 10204,
            proxy_config => $dirs->{work} . "/bm-dyntables-proxy-debug.conf",
            proxy_log => $dirs->{log} . "/bm-dyntables-proxy-debug.log",
            proxy_lockname => "run_dyntables_proxy_debug",

            proxy_acl => [ "//" ],  # разрешаем доступ ко всем таблицам
            log_requests_longer_than => 0,  # логируем все запросы

            # ходим только в локальный прокси
            local_proxy_hosts => [ Utils::Hosts::get_curr_host() ],
            public_proxy_hosts => [ ],
        },
    },

    'env-patch' => _parse_patch_str($ENV{BM_PATCH_STR}),
};

sub _parse_patch_str {
    my $str = shift // "";

    my $patch = {};
    for my $piece (split m/;/, $str) {
        next unless $piece;

        my ($path_str, $value) = $piece =~ m/^([^:]+):([^:]+)$/
        or die "Can't parse piece '$piece' in patch-line '$str'";

        my @path = split m@/@, $path_str;
        my $tail_ref = $patch;
        my $pretail_ref = undef;
        for my $item (@path) {
            $tail_ref->{$item} //= {};
            $pretail_ref = $tail_ref;
            $tail_ref = $tail_ref->{$item};
        }

        $pretail_ref->{ $path[$#path] } = $value;
    }

    return $patch;
}

1;
