package Utils::CompileTime;

use strict;
use warnings;

use Cwd qw(abs_path);
use POSIX qw(floor);
use File::Slurp qw(read_file write_file);
use Utils::LightCommon;
use Utils::SvnInfo qw(get_svn_info);

my $COMPILE_TIME = time();
my $REVISION = _find_revision();
my $SCRIPT = $0;


sub get_compile_time { return $COMPILE_TIME }
sub get_revision { return $REVISION }
sub get_revision_fname { return $Utils::LightCommon::options->{CompileTime_params}{revision_filename} }

sub get_revision_file_path {
    my (%prm) = @_;
    my $bm_path = $prm{bm_path} // abs_path($Utils::LightCommon::dirs->{root});
    my $rev_file_path = $bm_path . "/" . get_revision_fname();
    return $rev_file_path;
}

sub save_revision_to_file {
    my (%prm) = @_;
    my $revision = $prm{revision} || get_revision();
    my $revision_file = get_revision_file_path(bm_path => $prm{bm_path});
    write_file($revision_file, $revision);
}

sub status_str {
    my $compile_time = get_compile_time();
    my $date = scalar localtime $compile_time;
    my $elapsed = time() - $compile_time;

    my $hours = floor($elapsed / 3600);
    my $minutes = floor(($elapsed % 3600) / 60);

    my $revision = get_revision() // "(unknown)";
    
    return __PACKAGE__ . " for '$SCRIPT' was imported at $date ($hours hours $minutes minutes ago), from svn revision $revision";
}

sub _find_revision {
    my $svn_path = abs_path($Utils::LightCommon::dirs->{root});
    my $rev_file_path = get_revision_file_path(bm_path => $svn_path);

    # если есть файл с номером ревизии:
    return eval { my $revision = read_file($rev_file_path); chomp $revision; $revision } if -s $rev_file_path;

    my $svn_info = get_svn_info($svn_path);

    if (defined $svn_info) {
        return $svn_info->{revision};
    } else {
        return undef;
    }
}

