#include <rt-research/broadmatching/scripts/cpp-source/datacamp_tskv_downloader/DatacampTskvDownloader.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

#undef seed
#undef do_open
#undef do_close

SV* Convert(const char* string) {
    SV* result(newSV(0));
    sv_setpv(result, string);
    SvUTF8_on(result);
    return result;
}

MODULE = DatacampTskvDownloader		PACKAGE = DatacampTskvDownloader
PROTOTYPES: DISABLE

static bool
Download(outFilename, businessId, shopId)
    TString outFilename
    unsigned int businessId
    unsigned int shopId
    CODE:
        try {
            RETVAL = NIRT::DatacampTskvDownloader().Download(outFilename, businessId, shopId);
        } catch (const std::runtime_error& error) {
            std::string full_error_message = "ERROR: ";
            full_error_message += error.what();
            croak_sv(Convert(full_error_message.c_str()));
        }
    OUTPUT:
        RETVAL
