package Utils::Dicts;

use strict;

use utf8;
use open ':utf8';

use Data::Dumper;
use Utils::Words;

use base qw(Exporter);
our @EXPORT = (
    'load_words_dict',      #загрузка словаря, состоящего только из набора слов
);

sub load_words_dict {
    my ($source, $params) = @_;
    my $h = {};

    open(F, $source);
    while(<F>){
        chomp;
        s/#.*//g;   # Строки комментариев в файле
        my @arr = grep {$_} split(/\s+|,/,lc($_));
        if($params){
            next if scalar(@arr) > 1 && $params->{only_words};
            for my $w (@arr){
                if($params->{norm}){
                    $h->{word2norm($w)} = $w;
                }elsif($params->{snorm}){
                    $h->{word2snorm($w)} = $w;
                }
            }
        }else{
            $h->{$_} = $_ for @arr;
        }
    }
    close(F);

    return $h;
}


1;

