package Utils::LWP::Protocol::http;

use strict;
use warnings;
use parent 'LWP::Protocol::http';
use Utils::LWP::Override qw(get_peer_addr);

use Data::Dumper qw(Dumper);

sub _extra_sock_opts {
    my ($self, $host, $port) = @_;
    my @opts = $self->SUPER::_extra_sock_opts($host, $port);
    if (my $addr = get_peer_addr($host) ) {
        push @opts, (PeerAddr => $addr, Host => $host);
    }
    return @opts;
}

sub socket_class { 'LWP::Protocol::http::Socket' }

1;
