package Utils::LWP::Protocol::https;

use strict;
use warnings;
use parent 'LWP::Protocol::https';
use Utils::LWP::Override qw(get_peer_addr);

sub _extra_sock_opts {
    my ($self, $host, $port) = @_;
    my @opts = $self->SUPER::_extra_sock_opts($host, $port);
    if (my $addr = get_peer_addr($host) ) {
        push @opts, (PeerAddr => $addr, Host => $host, SSL_verifycn_name => $host);
    }
    return @opts;
}

sub socket_class { 'LWP::Protocol::https::Socket' }

1;
