package Utils::LightCommon;

# Настройки для скриптов, в которых не загружаем Common.pm, т.к. загрузка Common.pm замедляет работу скрипта.
# Здесь только хэши настроек (Utils::Hosts НЕ используем)

use strict;
use utf8;

use Cwd qw(abs_path);
use File::Basename qw(dirname);

our ($basePath, $dirs, $options);

# вычисляем путь к корню проекта
my $lib_utils_path = abs_path(dirname($INC{'Utils/LightCommon.pm'}));

$basePath = abs_path("$lib_utils_path/../../../");
my $arcadia_root_path = abs_path("$basePath/../../");

$dirs = {
    # Директории оканчиваются на '/' для корректной работы в случае симлинков (/opt/broadmatching/{scripts,dicts, ... } могут быть симлинками)
    arcadia => $arcadia_root_path.'/',
    root => $basePath.'/',
    raw_data => $basePath.'/raw-data/',
    gen_dicts => $basePath.'/gen-dicts/',
    bin_dicts => $basePath.'/bin-dicts/',       # Бинарные словари большого объема
    monitor_info => $basePath.'/monitor-info/',
    QTests => $basePath.'/QTests/',
    banners_generation_files => $basePath.'/temp/banners_generation_files/',
    tests_feed_files => $basePath.'/work/tests_feed_files/',
    tmpfs => $basePath.'/tmpfs/', # /opt/broadmatching/tmpfs - симлинк на tmpfs (создается при наливке машины/создании инстанса в qloud)
    yt_cdict_generation => '//home/broadmatching/cdict_generation',
    map { $_ => $basePath.'/'.$_.'/' } (
        'temp',
        'work',
        'scripts',
        'dicts',
        'log',
        'lock',
        'simpgraphs',
        'export',          # файлы для экспорта с bmgen
        'bin',             # бинарники BM
        'bin-dicts',
        'secrets',         # секреты https://wiki.yandex-team.ru/BM/Secrets/
        'configs',         # тут лежат конфиги apache2 и nginx
    ),

};

$dirs->{"cpp-source"} = $dirs->{scripts}."/cpp-source";

$options = {

    # утилита ya
    ya_path => $dirs->{arcadia}."ya",

    CompileTime_params => {
        revision_filename => '_svn_revision',
    },
};

1;

