package Utils::Math;

use strict;
use base qw(Exporter);
use Data::Dumper;
use List::Util qw(sum min max);

our @EXPORT = (
    'factorial',
    'binom',
    'permutation_by_number',
);
our @EXPORT_OK = @EXPORT;

sub range_product {
    my $i = shift;
    my $j = shift;
    my %par = @_;

    return undef if $i > $j;
    return 0 if $i == 0;

    my $add = $par{add} // 0;
    my $prod = 1;
    for my $k ($i .. $j) {
        $prod *= $k + $add;
    }

    return $prod;
}

our %__precomputed_factorials = (
    0 => 1, 1 => 1, 2 => 2, 3 => 6, 4 => 24, 5 => 120, 6 => 720, 7 => 5040,
    8 => 40320, 9 => 362880, 10 => 3628800, 11 => 39916800, 12 => 479001600,
);
our $__max_precomputed_factorial_n = max(keys %__precomputed_factorials);
our $__max_precomputed_factorial_value = max(values %__precomputed_factorials);

sub factorial {
    my $n = shift;

    return undef if $n < 0;
    return undef if $n != int($n);
    # use precomputed values of factorial
    if ($n <= $__max_precomputed_factorial_n) {
        return $__precomputed_factorials{$n};
    } else {
        my $maxn = $__max_precomputed_factorial_n;
        my $maxv = $__max_precomputed_factorial_value;
        return $maxv * range_product($maxn+1, $n);
    }
}

sub binom {
    my $n = shift;
    my $k = shift;

    return undef if $n < $k;
    return undef if $n < 0;
    return undef if $k < 0;

    $k = min($k, $n-$k);  # binom is symmetric
    # avoid general factorial definition as far as possible
    if ($k == 0) {
        return 1;
    } elsif ($k == 1) {
        return $n;
    } elsif ($k == 2) {
        return $n * ($n - 1) / 2;
    } elsif ($k == 3) {
        return $n * ($n - 1) * ($n - 2) / 6;
    } else {
        return range_product($k+1, $n) / factorial($k);
    }
}

# k-ая перестановка из n элементов
sub permutation_by_number {
    my $n = shift;
    my $k = shift;
    my $fc = factorial($n);
    die 'k should be in range [0, n!-1]' if $k < 0 || $k >= $fc;
    my @used = map { 0 } 0..$n-1;
    my @res = ();
    my $i = $n;
    while ($i > 0) {
        $fc /= $i;
        my $d = int($k / $fc) + 1;
        $k %= $fc;
        for my $j (0..$n-1) {
            $d-- unless $used[$j];
            unless ($d) {
                push @res, $j;
                $used[$j] = 1;
                last;
            }
        }
        $i--;
    }
    return @res;
}

1;
