package Utils::Regions;
use strict;

#Работа с регионами

use utf8;
use open ':utf8';

use Utils::Sys qw(include_cpan);
use Utils::Words;

use base qw(Exporter);
our @EXPORT_OK = qw/
    geobase_subtree
    geobase_subtree_cached
    get_countries
/;

my %geobase_subtree;
my $init_subtree_done = 0;

my $SUBTREE_CACHE;

# по списку плюс и минус регионов получить все регионы поддерева
sub geobase_subtree {
    my $regs = shift;
    _init_subtree();
    my (%plus, %minus);
    for my $r (@$regs) {
        my $id = abs($r);
        my @c = @{$geobase_subtree{$id} || []};
        push @c, $id;
        if ($r >= 0) {
            $plus{$_} = 1 for @c;
        } else {
            $minus{$_} = 1 for @c;
        }
    }
    return sort grep { !$minus{$_} } keys %plus;
}

sub geobase_subtree_cached {
    my $regs = shift;

    if (!$SUBTREE_CACHE) {
        Utils::Sys::include_cpan();  # for Tie::Cache
        require Tie::Cache;
        my %cache;
        tie %cache, 'Tie::Cache', {MaxBytes => 50_000_000};
        $SUBTREE_CACHE = \%cache;
    }

    my $key = join(',', sort @$regs);
    my $val = $SUBTREE_CACHE->{$key};
    if (!$val) {
        $val = [ geobase_subtree($regs) ];
        $SUBTREE_CACHE->{$key} = $val;
    }

    return @$val;
}

# посчитать все подрегионы для всех регионов
sub _init_subtree {
    return if $init_subtree_done;

    require geobaselite;
    my %sub;
    while (my ($r, $inf) = each %geobaselite::Region) {
        my @parents = @{$inf->{path} || []};
        push @parents, $r;  # для единообразия -- subtree включает саму вершину
        push @parents, 0;  # в Директе '0' означает 'все регионы'
        $sub{$_}{$r} = 1 for @parents;
    }
    while (my ($r, $subh) = each %sub) {
        $geobase_subtree{$r} = [ sort keys %$subh ];
    }

    $init_subtree_done = 1;
}

# Возвращает список всех стран данных регионов (с учётом минус-регионов)
sub get_countries {
    my $reg_arr = shift;
    require geobaselite;

    my $Region = \%geobaselite::Region;

    # раньше в Директе 0 означало "все регионы", сейчас в тасках этого не видно (2018-11-15)
    # но на всякий случай заменяем 0 на 10000 (Земля)
    my @regs = map { $_ == 0 ? 10000 : $_ } @$reg_arr;
    my @plus = grep { $_ > 0 } @regs;
    my %minus = map { (-$_) => 1 } grep { $_ < 0 } @regs;

    my %seen_countries;

    while (@plus) {
        my $reg = shift @plus;
        my $inf = $Region->{$reg};
        next if !$inf;  # не найден в геобазе:(
        my $type = $inf->{type};
        if ($type == 3) {
            # нашли страну, всё
            $seen_countries{$reg} = 1;
        } elsif ($type > 3) {
            # регион Уже страны, поднимаемся по дереву наверх до ближайшей страны
            $seen_countries{$_} = 1 for grep { $Region->{$_}{type} == 3 } @{$inf->{path}};
        } else {
            # регион шире страны, идём по поддереву, но останавливаемся на минус-регионах
            my @chld = grep { !$minus{$_} } @{$inf->{chld}};
            push @plus, @chld;
        }
    }

    return sort { $a <=> $b } keys %seen_countries;
}

1;
