package Utils::RestartSettings;
use strict;

use utf8;
use LWP::UserAgent; # TODO использовать UserAgent с hard_timeout (scripts/lib/ObjLib/UserAgent.pm)
use Encode;
use Utils::Sys qw( print_err print_log switch_to_ipv6 );
use Utils::Hosts qw ( get_hosts get_host_datacenter );
use Utils::Common;
use Project;

my $bm_path = $Utils::Common::options->{dirs}{root};

# hosts - ссылка на массив хостов

our $settings = {
    bmapi    => {
        host_role           => 'bmapi',
        restart_interval    => 10,
        start_hour          => 21,
        start_minute        => 00,
        cmds                => [
            "$bm_path/scripts/broadmatching-server/fcgi-http-server restart >> $bm_path/log/fcgi-http-server.log 2>>$bm_path/log/fcgi-http-server.err",
        ],
        check_host          => sub {
            my ($host) = @_;

            switch_to_ipv6();

            my $ua = LWP::UserAgent->new;
            $ua->timeout(10);

            my $url = "http://$host/fcgi-bin/?act=alive";
            print_err("url: $url");
            my $response = $ua->get($url);
            if(!$response->is_success) {
                print_err($response->status_line);
                return 0;
            }

            print_err("$host response: ".$response->decoded_content);

            return length($response->decoded_content) > 0;
        }
    },

    'bmcdict-front' => {
        host_role           => 'bmcdict-front',
        restart_interval    => 30,
        start_hour          => 4,
        start_minute        => 0,
        cmds                 => [
            "$bm_path/scripts/cdict/stop.pl datoteka_cdict >> $bm_path/log/cdict-stop-server.log 2>>$bm_path/log/cdict-stop-server.err &",
        ],
        check_host          => sub {
            my ($host) = @_;
            my $proj = Project->new({});

            $proj->cdict_client->{host} = $host;
            my $resp = $proj->cdict_client->exec_command_once("getnorm\tbnr_count\ttoyota");
            print_err("$host response: " . ($resp || "undef"));

            return defined($resp) && $resp =~ /^YES/;
        },
    },

    "bmcdict-front02" => {
        host_role           => 'bmcdict-front02',
        restart_interval    => 30,
        start_hour          => 4,
        start_minute        => 0,
        cmds                 => [
            "$bm_path/scripts/cdict/stop_server.pl >> $bm_path/log/cdict-stop-server.log 2>>$bm_path/log/cdict-stop-server.err &",
        ],
        check_host          => sub {
            my ($host) = @_;
            my $proj = Project->new({});

            $proj->cdict_client->{host} = $host;
            my $resp = $proj->cdict_client->exec_command_once("getnorm\tcount\ttoyota");
            print_err("$host response: " . ($resp || "undef"));

            return defined($resp) && $resp =~ /^YES/;
        },
    },
};

1;
