#include "rt-research/broadmatching/scripts/cpp-source/static_map/static_map_engine.h"

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

MODULE = StaticMap		PACKAGE = StaticMap
PROTOTYPES: DISABLE

StaticMapEngine *
StaticMapEngine::new(data_file_directory)
    const char* data_file_directory

void
StaticMapEngine::LoadData(data_file_directory)
    const char* data_file_directory

SV*
StaticMapEngine::Value(key)
    char* key
    CODE:
        const char* res = THIS->Value(key);
        SV* token_sv( newSV(0) );    // create a scalar
        sv_setpv(token_sv, res);
        SvUTF8_on(token_sv);
        RETVAL = token_sv;
    OUTPUT:
        RETVAL

const char* 
StaticMapEngine::GetSubstr(key, prx)
    char* key
    char* prx

const char* 
StaticMapEngine::LangValue(key, lang)
    char* key
    char* lang

const char* 
StaticMapEngine::GetNorm(text, lang);
    char* text
    char* lang

void 
StaticMapEngine::AddStop(text, lang);
    char* text
    char* lang

bool 
StaticMapEngine::IsStop(text, lang);
    char* text
    char* lang

SV* 
StaticMapEngine::norm_word(text, lang);
    char* text
    char* lang
    CODE:
        const char* res = THIS->LangValue(text, lang);
        //RETVAL = newSV();
        //printf("DDDDDD %s\n", res);
        SV* token_sv( newSV(0) );    // create a scalar
        sv_setpv(token_sv, res);
        SvUTF8_on(token_sv);
        RETVAL = token_sv;
    OUTPUT:
        RETVAL

AV*
StaticMapEngine::orig_words(text);
    char* text
    CODE:
        std::vector<char*> tokens;
        THIS->tokenizer.GetTokensLite(text, tokens);
        std::vector<char*>::iterator iter( tokens.begin() );
        RETVAL = newAV();               // create an array
        sv_2mortal( (SV*)RETVAL );      // "mortalize"
        for ( ; iter != tokens.end(); iter++ ) {
            SV* token_sv( newSV(0) );    // create a scalar
            sv_setpv(token_sv, *iter);
            SvUTF8_on(token_sv);
            av_push( RETVAL, token_sv );
        }
    OUTPUT:
        RETVAL

AV*
StaticMapEngine::words(text);
    char* text
    CODE:
        std::vector<char*> tokens;
        THIS->tokenizer.GetTokensLite(text, tokens);
        std::vector<char*>::iterator iter( tokens.begin() );
        RETVAL = newAV();               // create an array
        sv_2mortal( (SV*)RETVAL );      // "mortalize"
        for ( ; iter != tokens.end(); iter++ ) {
            SV* token_sv( newSV(0) );    // create a scalar
            sv_setpv(token_sv, *iter);
            SvUTF8_on(token_sv);
            av_push( RETVAL, token_sv );
        }
    OUTPUT:
        RETVAL

AV*
StaticMapEngine::norm_words(text, lang);
    char* text
    char* lang
    CODE:
        std::vector<char*> tokens;
        THIS->tokenizer.GetTokensLite(text, tokens);
        std::vector<char*>::iterator iter( tokens.begin() );
        RETVAL = newAV();               // create an array
        sv_2mortal( (SV*)RETVAL );      // "mortalize"
        for ( ; iter != tokens.end(); iter++ ) {
            if((*iter)[0] == '-'){ continue; } // Удаляем минус-слова
            SV* token_sv( newSV(0) );    // create a scalar
            sv_setpv(token_sv, THIS->LangValue(*iter, lang));
            SvUTF8_on(token_sv);
            av_push( RETVAL, token_sv );
        }
    OUTPUT:
        RETVAL

SV* 
StaticMapEngine::norm_phr(text, lang);
    char* text
    char* lang
    CODE:
        const char* res = THIS->GetNorm(text, lang);
        //RETVAL = newSV();
        //printf("DDDDDD %s\n", res);
        SV* token_sv( newSV(0) );    // create a scalar
        sv_setpv(token_sv, res);
        SvUTF8_on(token_sv);
        RETVAL = token_sv;
    OUTPUT:
        RETVAL

SV* 
StaticMapEngine::norm_phrase_list(text, lang);
    char* text
    char* lang
    CODE:
        const char* res = THIS->GetNormList(text, lang);
        //RETVAL = newSV();
        //printf("DDDDDD %s\n", res);
        SV* token_sv( newSV(0) );    // create a scalar
        sv_setpv(token_sv, res);
        SvUTF8_on(token_sv);
        RETVAL = token_sv;
    OUTPUT:
        RETVAL

AV* 
StaticMapEngine::get_subphrases(text);
    char* text
    CODE:
        std::vector<char*> tokens;
        THIS->GetSubphrases(text, 6, tokens);
        std::vector<char*>::iterator iter( tokens.begin() );
        RETVAL = newAV();               // create an array
        sv_2mortal( (SV*)RETVAL );      // "mortalize"
        for ( ; iter != tokens.end(); iter++ ) {
            SV* token_sv( newSV(0) );    // create a scalar
            sv_setpv(token_sv, *iter);
            SvUTF8_on(token_sv);
            av_push( RETVAL, token_sv );
        }
    OUTPUT:
        RETVAL

void
StaticMapEngine::DESTROY()
