package Utils::SubsetIndex;
use strict;

use utf8;
use open ':encoding(utf8)';

use std;
use base qw(ObjLib::Obj);
use List::Util qw(min);
use Utils::Common;

# настройки объекта:
#
# dont_sort                 не сортировать элементы подмножеств
#

sub init {
    my ($self) = @_;

    $self->{root} = {};
    $self->{empty} = " ";
}

sub fill_index {
    my ($self, @subsets) = @_;
    my $h = {};

    for my $ss (@subsets) {
        my $node = $h;
        for my $el ($self->_sort_items(@$ss)) {
            $node = ($node->{$el} ||= {});
        }
        $node->{$self->{empty}}++;
    }

    $self->{root} = $h;
}

sub _sort_items {
    my ($self, @items) = @_;

    return @items if $self->{dont_sort};
    return sort @items;
}

sub _search_tree {
    my ($self, $tree, $prefix, $set, $pos, $result, $max_dist) = @_;

    push @$result, $prefix if $tree->{$self->{empty}} && @$prefix;

    my $end = @$set;
    if($max_dist && $tree != $self->{root}) {
        $end = min($end, $pos + $max_dist);
    }

    for (my $i = $pos; $i < $end; $i ++) {
        my $h = $tree->{$set->[$i]};
        $self->_search_tree($h, [@$prefix, $set->[$i]], $set, $i + 1, $result, $max_dist) if $h;
    }
}

# поиск подмножеств из индекса
# опции:
# max_dist      максимальное расстояние между соседними найденными словами (имеет смысл для индексов со свойством dont_sort)
sub search_subsets {
    my ($self, $set, %opts) = @_;
    my @result;

    $self->_search_tree($self->{root}, [], [$self->_sort_items(@$set)], 0, \@result, $opts{max_dist});

    return @result;
}

1;
