package Utils::SvnInfo;

use strict;
use warnings;

use base qw(Exporter);
our @EXPORT_OK = qw(get_svn_info);

use Cwd qw(abs_path);
use Date::Parse qw(str2time);
use Utils::LightCommon;

sub get_svn_info {
    my $svn_path = shift // abs_path($Utils::LightCommon::dirs->{root});

    my $ya = $Utils::LightCommon::options->{ya_path};
    my $cmd = "cd $svn_path && timeout -k 10 100 $ya tool svn </dev/null info 2>&1";
    my $svn_info_str = `$cmd`;
    return undef if $?;

    my $svn_info = {};

    $svn_info->{revision} = $1 if $svn_info_str =~ m/Revision: (\d+)/;
    $svn_info->{last_changed} = str2time($1) if $svn_info_str =~ m/Last Changed Date: (.+)/;

    return $svn_info;
}
