#include <market/library/url_checker/url_checker.h>

#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>


MODULE = Utils::URLValidator::URLValidator PACKAGE = Utils::URLValidator::URLValidator
PROTOTYPES: DISABLE

NMarket::TURLChecker*
new(package)
    CODE:
        RETVAL = new NMarket::TURLChecker();
    OUTPUT:
        RETVAL

MODULE = Utils::URLValidator::URLValidator PACKAGE = NMarket::TURLCheckerPtr
PROTOTYPES: DISABLE

bool
NMarket::TURLChecker::validate_url(url)
    INPUT:
        const char* url;
    CODE:
        const auto result = THIS->CheckAbsoluteURL(url, true);
        RETVAL = result.IsGood() && !result.IsEmpty();
    OUTPUT:
        RETVAL

void
NMarket::TURLChecker::DESTROY()
    CODE:
        delete THIS;

