#include <util/string/split.h>
#include "rt-research/broadmatching/scripts/cpp-source/xml_parser/xml_parser.h"

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

#undef seed
#undef do_open
#undef do_close

SV* Convert(const char* string) {
    SV* result(newSV(0));
    sv_setpv(result, string);
    SvUTF8_on(result);
    return result;
}

typedef TMaybe<TErrorOrWarning>* TErrorOrWarningPtr;

MODULE = XMLParser		PACKAGE = XMLParser
PROTOTYPES: DISABLE

static TErrorOrWarningPtr
grep(source_file_path, target_file_path, search_tags_text, is_strong_mode, feed_type)
    const char* source_file_path
    const char* target_file_path
    const char* search_tags_text
    bool is_strong_mode
    const char* feed_type
    CODE:
        TVector<TString> search_tags = StringSplitter(search_tags_text).Split(',');
        TMaybe<TErrorOrWarning> result = XMLParser::Grep(
            source_file_path,
            target_file_path,
            search_tags.begin(),
            search_tags.end(),
            is_strong_mode,
            feed_type
        );
        RETVAL = new TMaybe<TErrorOrWarning>(result);
    OUTPUT:
        RETVAL


MODULE = XMLParser		PACKAGE = TErrorOrWarningPtr
PROTOTYPES: DISABLE

const char *
message(result)
    TErrorOrWarningPtr result
CODE:
    RETVAL = (*result)->message.en.c_str();
OUTPUT:
    RETVAL

const char *
message_ru(result)
    TErrorOrWarningPtr result
CODE:
    RETVAL = (*result)->message.ru.c_str();
OUTPUT:
    RETVAL

bool
is_error(result)
    TErrorOrWarningPtr result
CODE:
    RETVAL = result->Defined() && !(*result)->is_warning;
OUTPUT:
    RETVAL

bool
is_warning(result)
    TErrorOrWarningPtr result
CODE:
    RETVAL = result->Defined() && (*result)->is_warning;
OUTPUT:
    RETVAL

void
DESTROY(result)
    TErrorOrWarningPtr result
CODE:
    delete result;
