package YtProjectLaunchHelper;

# Модуль c функциями, полезными для запуска операции на yt, в которой будут доступны библиотеки из lib
# Модуль задуман как отчуждаемый, поэтому специально ничего не импортирует из нашего кода и из CPAN
use strict;

use utf8;

use Storable qw(nstore retrieve);
use File::Temp qw(tempdir);
use constant CFG_FILENAME => "job_cfg";

sub new {
    my ($class, $data) = @_;
    my $self = bless {%$data}, $class;
    return $self;
}

sub resource_url {
    my $self = shift;
    return $self->{resource_url};
}

sub sandbox_token {
    my $self = shift;
    return $self->{sandbox_token};
}

sub temp_dir {
    my $self = shift;
    return $self->{temp_dir};
}

sub cfg_file {
    my $self = shift;
    if (@_) {
        $self->{cfg_file} = shift;
    }
    return $self->{cfg_file};
}

sub resource_download_cmd {
    my $self = shift;

    my $resource_url = $self->resource_url;
    my $token = $self->sandbox_token;
    my $temp_dir = $self->temp_dir;

    my $cmd = undef;

    if ($resource_url && $temp_dir) {
        my $header = $token ? "--header=\"Authorization: OAuth \{$token\}\"" : '';
        $cmd = "wget $header -O - $resource_url --quiet | tar -xf - -C $temp_dir";
    }
    return $cmd;
}

sub additional_console_params {
    my $self = shift;
    my $temp_dir = $self->temp_dir;
    my @opts =  (
        "--local-file=$temp_dir/broadmatching.tar.gz",
        "--local-file=$temp_dir/mr_perl",
        "--local-file=$temp_dir/perllibs.tgz",
    );
    push @opts, "--local-file=".$self->cfg_file if $self->cfg_file;
    return @opts;
}

sub save_job_cfg_host {
    my ($self, $cfg) = @_;
    my $cfg_dir = tempdir('job_cfg_XXXX', DIR=>$self->temp_dir, CLEANUP => 1);
    my $cfg_file = $cfg_dir.'/'.CFG_FILENAME;
    nstore $cfg, $cfg_file;
    $self->cfg_file($cfg_file);
    return $cfg_file;
}

sub load_job_cfg_yt {
    my $self = shift;
    my $cfg_file = './'.CFG_FILENAME;
    return retrieve($cfg_file);
}

1;
