package geobaselite;

=head1 DESCRIPTION

 Same as geobase except:
 * contains only used fields(name, path, parents, chld, type)
 * stored in file in binary format(Storable)

=cut

use strict;
use warnings;
use Exporter;
use utf8;
use Storable;
use POSIX;
use Utils::LightCommon;
our @ISA = qw(Exporter);
our @EXPORT = qw(%Region);
our $date_modify='Wed Nov 25 15:40:21 2015';
our $date_modify_unix=1448466021;
our %Region;

eval {
    my $basePath = $Utils::LightCommon::basePath;
    my $geobase = retrieve("$basePath/bin-dicts/geo/geobaselite.stor");
    %Region = %$geobase;
};
if ($@) {
    my $time = POSIX::strftime("%Y-%m-%d %H:%M:%S", localtime);
    print STDERR join("\t", $time, "[$$]", "ERROR: failed to load bin-dicts/geo/geobaselite.stor"), "\n";
    die "Geobase load failed";
}

1;
