=head1 Название

std - Прагма, содержащая в себе другие необходимые прагмы и модули, необходимые в любой точке проекта.

=head1 Описание

Прагма C<std> заменяет:

 use strict;
 
 use Data::Dumper;
 use Scalar::Util qw(set_prototype blessed dualvar isweak readonly refaddr
                     reftype tainted weaken isvstring looks_like_number);
 
 use Utils::Std::<Модули в Utils:STD>

=head1 Модули

=head2 Внешние

=over

=item Data::Dumper

=item Scalar::Util

=back

=head2 Utils::Std::

=over

=item L<Utils::Std::Log>

=back

=cut

package std;

use strict;

use Data::Dumper;
use Scalar::Util;

$Data::Dumper::Useqq = 1;

{ no warnings 'redefine';
    sub Data::Dumper::qquote {
        my $s = shift;
        return "'$s'";
    }
}

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

sub import {
    $^H |= 0x00000002 | 0x00000200 | 0x00000400;
    
    Data::Dumper->export_to_level(1, qw(Dumper));
    Scalar::Util->export_to_level(1, undef, qw(set_prototype blessed dualvar isweak readonly refaddr
                                               reftype tainted weaken isvstring looks_like_number));

#    Utils::Std::Log->export_to_level(1);
};

1;

=head1 Автор

I<Свистунов Сергей>
