#!/usr/bin/perl -w
use strict;

use utf8;
use open ":utf8";

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
use POSIX qw(strftime);
use Storable qw(dclone);

use Digest::MD5 qw(md5 md5_hex);
use Data::Dumper;
use Encode;
use Time::HiRes qw(gettimeofday tv_interval);
use Getopt::Long;

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Common;

use Utils::Sys qw(
    save_json
    load_json
    dir_files
    rsync
    log_msg_fmt
    uniq
    print_err
    do_safely
    handle_errors
    get_file_lock
    wait_for_file_lock
    fork_tasks
    make_good_utf_string
    mtime
);

use Utils::Hosts qw(get_hosts get_host_role get_curr_host get_host_info check_addrinfo get_alive_hosts get_host_project);
use Utils::DB qw(
    get_tbl_update_time
    array2text
);

select STDERR; $|++;
select STDOUT; $|++;

handle_errors( DIE => {stack_trace => 1} );

cdict_monitor();

exit(0);


sub cdict_monitor {
    my $proj = Project->new({});
    $proj->log("cdict_monitor ...");

    my $file_in = $Utils::Common::options->{dirs}{scripts}."/monitors/cdict-monitor-data";

    my @hostport_cmd = map { my $h = {};  @{$h}{qw[ hostport cmd ]} = split /\t/;  $h }  map { chomp; $_ }  `cat $file_in`;
    do { $_->{cmd} =~ s/\\t/\t/g;  $_->{cmd} =~ s/\\\\/\\/g }  for @hostport_cmd;
    #print Dumper(\@hostport_cmd);
    die "Void hostport_cmd!"   if @hostport_cmd < 3;

    my @cdict_names = (
        'cdict_client',     # 'chronicle_cdict',
        'datoteka_cdict',
        #'',
    );
    my %name2hostport = map {
        my $name = $_;
        my $cl = $proj->{$_};
        #($name => ( $cl  ?  $cl->host.":".$cl->port : do { $proj->log("WARN: void $name"); '' } ))
        ($name => ( $cl  ?  $cl->host.":".$cl->port : '' ))
    } @cdict_names;
    #print Dumper(\%name2hostport);

    my $count = 1;
    my $tests_count = 1;
    for my $n (1 .. $count) {
        for my $cdict_name (grep { $name2hostport{$_} } @cdict_names) {
            my $cdict_client = $proj->{$cdict_name};
            my $hostport = $name2hostport{$cdict_name};
            #$proj->log("cdict: $cdict_name $hostport");
            for my $cmd (
                grep {$_}  (map { $_->{cmd} }  grep { $_->{hostport} eq $hostport } @hostport_cmd)[ 0 .. $tests_count - 1 ]
            ) {
                #$proj->log("cdict: $cdict_name $hostport $cmd");
                $proj->log("cdict: $cdict_name $hostport");
                my $res = $cdict_client->exec_command_once($cmd);
                #$proj->log("res: " . ($res // '__UNDEF__'));
                unless (defined($res)) {
                    $proj->log("ERROR: Void res! $cdict_name $hostport");
                }
            }
        }
        #sleep 1;
    }

    $proj->log("cdict_monitor done");
}
