#!/usr/bin/perl -w
use strict;
use utf8;

# парсинг логов с ошибками

use open ':utf8';
use Sys::Hostname;  # не используем Utils::Hosts, чтобы зависеть только от Core Modules
use FindBin;
use lib "$FindBin::Bin/../lib";
use Getopt::Long qw/GetOptions/;
use Utils::Hosts qw/get_curr_host/;
use BM::SolomonClient;

# scripts/monitors/check-logs.pl
# scripts/monitors/check-logs.pl --print   -  Только вывести на экран

my $do_print_only;
# на случай ошибок в основных модулях и при проверке логов всё оборачиваем в eval
eval {
    require Utils::Sys;
    require BM::Monitor::Logs;

    my %opt = ();
    GetOptions(\%opt, 'hours=n', 'print');
    $do_print_only = $opt{print} // 0;
    my $hours = $opt{hours} // 3;

    if ($hours < 1) {
        print "ERROR: hours count must be a positive number\n";
        exit(1);
    }

    # находим крайние границы того интервала, в который попадают все целые часы за последние $hours часов с текущего момента
    my $cur_time = time;
    my $end_entire_hour = $cur_time - ($cur_time % 3600) - 3600;
    my $start_entire_hour = $end_entire_hour - ($hours - 2) * 3600;

    unless ($do_print_only) {
        Utils::Sys::get_file_lock() or do {
            Utils::Sys::print_err("ERROR: check-logs is already running, exit"); # TODO - заменить на WARN ?
            exit(1);   # TODO exitcode - ?
        }
    }

    my $start_time = time;
    my ($errors, $err_warn_counter, $err_sum, $warn_sum) = BM::Monitor::Logs::get_logs_errors($hours);
    my $result_time = time - $start_time;

    Utils::Sys::print_err("======== Found $err_sum errors. ========");
    Utils::Sys::print_err("======== Found $warn_sum warnings. ========");
    Utils::Sys::print_err("======== Handling time: $result_time seconds. ========");

    if ($do_print_only) {
        # Print only
        BM::Monitor::Logs::print_logs_errors($errors);
    } else {
        # Send and save errors
        BM::Monitor::Logs::send_logs_errors_diff($errors);
        BM::Monitor::Logs::save_logs_errors($errors);
        BM::Monitor::Logs::send_logs_errors_metrics($err_warn_counter, $start_entire_hour, $end_entire_hour);
        Utils::Sys::print_err("CHECK_LOGS_OK");
        BM::SolomonClient->new()->set_success_script_finish("check-logs");
    }

    unless ($do_print_only) {
        Utils::Sys::release_file_lock();
    }
   
    exit(0);
};

print "ERROR: " . ($@ // 'UNDEF') . "\n";

# В режиме $do_print_only не нужно отправлять письма
if ($do_print_only) {
    exit(1);
}

# эту часть - не меняем!!!
if ($@) {
    my $host = Sys::Hostname::hostname();
    my $sendmail = "/usr/sbin/sendmail -t";

    open SEND, "|$sendmail";

    print SEND "From: SendError\n";
    print SEND "To: bm-dev\@yandex-team.ru\n";
    print SEND "Subject: $host: errors in monitoring!\n";
    print SEND "Content-type: text/plain; charset=UTF-8\n\n";
    print SEND scalar(localtime)."\n\n";
    print SEND "Errors:\n$@\n";

    close SEND;
    exit(1);
}

exit(0);
