#!/usr/bin/perl -w
use strict;
use utf8;

# скрипт для сбора ошибок в логах
# выполняется на bmfront

use open ':utf8';

use DBI;
use Data::Dumper;
use POSIX qw(strftime);
use File::Temp qw(tempdir);

use FindBin;
use lib "$FindBin::Bin/../lib";
#use BM::Monitor;
use Project;
use BM::Monitor::Logs;
use BM::Monitor::Utils;
use BM::SolomonClient;
use Utils::Sys qw(
    dir_files
    get_file_lock
    release_file_lock
    print_err
    handle_errors
    time_unix2db
    load_json
    save_json
    md5int
    rsync
    do_safely
);
use Utils::Funcs qw(
    prm_list_filter
);
use Utils::Hosts qw[ get_hosts get_host_role get_short_hostname ];
use Project;

get_file_lock() or exit(0);
handle_errors();

my @unsuccesfull;


sub solomon_send_host_success_mark {
    my $host = shift;
    BM::SolomonClient->new()->push_single_sensor({
        cluster => "host_info",
        service => "scripts",
        sensor  => "collect_logs_from_host",
        value   => 1,
        labels  => {
            host => $host,
        },
    });
}

eval {
    my $opt = $Utils::Common::options;
    my $proj = Project->new;
    my $dbh = $proj->monitoring_dbh;
    my $tmpd = tempdir('coll-logs.tmp.XXXX', DIR => $opt->{dirs}{temp});
    print_err("using temp dir $tmpd");

    # для каждого хоста скачиваем лог и вставляем в базу
    my $link = $logs_errors_file{current};
    $link =~ s/.*\///;

    my $values_new = [];  # Список новых ошибок

    HOST: for my $host (get_hosts()) {
        next if (get_host_role($host) =~ /idle/i);

        print_err("processing host $host ...");
        my $host_short = get_short_hostname($host);
        $host_short =~ s/\.yandex\.ru$//;

        my $tmp_file = "$host.logs-errors.json";
        if (not rsync("rsync://$host/bmexport/$link",
                out => "$tmpd/$tmp_file",
                add_opt => "--copy-links",
                logger => $proj,
                WARN_ONLY => 1,
                contimeout => 10,
                timeout => 10,
                system_timeout => 10,
                max_attempt_count => 2,
            ) and not eval {
                # Нужно, если rsync не поднят (например, catalogia-mod-light) или же должен быть поднят, но упал
                my $cmd = "scp $host:/opt/broadmatching/export/logs_errors-current.json $tmpd/$tmp_file";
                print_err("WARN: rsync from $host failed! Try ( $cmd ) ...");
                Utils::Sys::do_sys_cmd($cmd, timeout => 10, kill_after => 2, no_die => 1);
            }
        ) {
            push @unsuccesfull, "Host:$host";
            print_err("WARN: rsync from $host failed: $!");  # ERROR не нужен, т.к. есть индикатор, проверяющий метку COLLECT_LOGS_OK в логах
            next HOST;
        };
        my $values = load_json("$tmpd/$tmp_file");

        if (ref($values) ne 'ARRAY') {
            print_err("ERROR: Could not load data from file (remote: $link, local: $tmpd/$tmp_file)");
            next HOST;
        }

        if (!@$values) {
            print_err('nothing to do!');
            print_err("COLLECT_LOGS_${host_short}_OK");
            solomon_send_host_success_mark($host);
            next HOST;
        }

        eval {
            my @keys_input = qw[ ErrorID host file time pid error type ];
            for my $val (@$values) {
                $val->{time} = time_unix2db($val->{time});
                $val->{host} = $host;
                $val->{ErrorID} = md5int(join(',', (map { $val->{$_} // '' }  grep { $_ ne 'ErrorID'  and  $_ ne 'type' }  @keys_input)));
            }

            BM::Monitor::Utils::add_aux_fields_to_events_list($values, event_type => 'error');
            for (
                [ 'ErrorTextUniq', 'ErrorIDUniq', { } ],
                [ 'ErrorTextUniqReduceHost', 'ErrorIDUniqReduceHost', { reduce_host => 1 } ],
            ) {
                my ($fld, $fld_id, $prm) = @{$_};
                $_->{$fld} = BM::Monitor::Logs::error2str($_, %$prm)    for @$values;
                $_->{$fld_id} = md5int($_->{$fld})   for @$values;
            }
            my @keys_add = qw[ project host_role host_group host_short file_template script_name  ErrorTextUniq ErrorIDUniq ErrorTextUniqReduceHost ErrorIDUniqReduceHost ];
            my @keys_all = (@keys_input, @keys_add);
            my %key2sql = (
                host => 'Host',  file => 'File',  time => 'ErrorTime',  pid => 'PID',  error => 'ErrorText',  type => 'ErrorInfo',
                host_role => 'HostRole', host_group => 'HostGroup',  host_short => 'HostShort',
            );
            my @keys_sql = map { $key2sql{$_} || $_ } @keys_all;

            my @values_str;
            for my $val (@$values) {
                push @values_str, "(" . join(',', (map {
                        $dbh->quote($val->{$_})
                    } @keys_all)) . ")";
            }

            my $stm;

            # Выбираем ошибки, которых нет в базе
            $stm = "select ErrorID from MonitorErrors where ErrorID in (" . join(",", (map {$_->{ErrorID}} @$values) ) . ")";
            my %id_old = do_safely(sub { map { $_->{ErrorID} => 1} @{ $dbh->List_SQL($stm) // [] }; },   no_die => 1);  # Если не удалось выполнить List_SQL, то ошибки в письмах могут повторяться 
            push @$values_new, (grep { not $id_old{ $_->{ErrorID} }} @$values);

            # insert в базу
            $stm = 'insert ignore into MonitorErrors '
                      . ' (' . join(',',  map { '`'. $_ . '`' } @keys_sql ) . ') '
                      . ' values '
                      . join(',', @values_str);
            $dbh->do($stm)
                or print_err("ERROR: dbi: ".$dbh->errstr) and next HOST;

            print_err("COLLECT_LOGS_${host_short}_OK");
            solomon_send_host_success_mark($host);
        };
        if ($@) {
            print_err("ERROR: " . change_newline_to_spaces($@));
        }
    };

    my $file_errors_sent = $logs_errors_file{sent_to_subscribers};
    my %errors2time_new;
    if (@$values_new) {

        # Получаем ошибки, которые посылать не надо
        #my %err_str_old = 
        my %errors2time_sent_old = do_safely( sub {

                #my $stm = "select * from MonitorErrors where ErrorTime >= '$time_ignore'";
                #map { BM::Monitor::Logs::error2str($_) => 1 } @{ $dbh->List_SQL($stm) // [] };

                my $errors2time_sent_old = load_json($file_errors_sent);
                if (not ref($errors2time_sent_old) eq 'HASH') {
                    print_err("WARN: Could not get previous errors from file ($file_errors_sent)");
                    $errors2time_sent_old = {};
                }

                #map { BM::Monitor::Logs::error2str($_) => 1 } @{ $dbh->List_SQL($stm) // [] };
                %$errors2time_sent_old;
            },
            no_die => 1,
        );

        my $max_ignore_hours_old = 48;   # Сколько времени не посылать ошибку в письме, если ошибка повторяется
        my $time_ignore = time_unix2db(time - 3600 * $max_ignore_hours_old);
        delete $errors2time_sent_old{$_}   for grep { $errors2time_sent_old{$_} lt $time_ignore } keys %errors2time_sent_old;   # Удаляем из %errors2time_sent_old ошибки, которые были отправлены слишком давно

        my %errors_new = map { BM::Monitor::Logs::error2str($_, reduce_host => 1) => $_ }
            sort { $a->{time} cmp $b->{time} } @$values_new;    # Если ошибки повторяются (с точностью до совпадения error2str), берем последнюю
        delete $errors_new{$_}   for grep { $errors2time_sent_old{ $_ }} keys %errors_new;  # Удаляем ошибки, которые уже были отправлены недавно (с точностью до совпадения error2str)
        $values_new = [ values %errors_new ];

        %errors2time_new = map {
            $_ => ( $errors_new{$_}  ?  $errors_new{$_}{time}  :  $errors2time_sent_old{$_}  )
        } (keys %errors_new,  keys %errors2time_sent_old);  # Для сохранения в $file_errors_sent
    }

    if (@$values_new) {
        BM::Monitor::Utils::add_aux_fields_to_events_list($values_new, event_type => 'error');

        my $res = BM::Monitor::Utils::send_events_to_subscribers($proj, $values_new, BM::Monitor::Logs::get_subscriptions,
            fields_title => [qw[ host_short script_name ]],
            fields_hierarchy => [qw[ file ]],
            fields => [qw[ time error ]],
            title => "Logs",
        );
        if ($res) {
            $proj->log("Saving errors to $file_errors_sent ...");
            save_json(\%errors2time_new, $file_errors_sent)  ?
                $proj->log("Saved.")  :
                $proj->log("ERROR: save_json failed");
        } else {
            $proj->log("ERROR: send_events_to_subscribers returned 0");
            push @unsuccesfull, "send_events_to_subscribers";
        }
    } else {
        print_err("No values to send");
    }

    unlink $tmpd.'/'.$_ for dir_files($tmpd);
    rmdir $tmpd;
};
if ($@) {
    print_err("ERROR: " . change_newline_to_spaces($@));
} elsif (@unsuccesfull) {
    print_err("WARN: Unsuccessful: " . join(", ", @unsuccesfull));
}

BM::SolomonClient->new()->set_success_script_finish("collect-logs");
release_file_lock();
exit(0);



sub change_newline_to_spaces {
    my $s = shift;
    $s =~ s/\n/  /g;
    return $s;
}

