#!/usr/bin/perl

use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/../lib";
use BM::Monitor::Utils;
use Getopt::Long;
use Utils::Sys qw/handle_errors/;
use Utils::Common;

handle_errors;

sub main {

    my %opt = ();
    GetOptions(\%opt, 'time=s', 'host=s', 'is_virtual_host=s');

    my $path = $ARGV[0];
    my $value = $ARGV[1];
    
    BM::Monitor::Utils::graphite_client()->send_value(
        [$path], $value, time => $opt{time}, host => $opt{host},
        is_virtual_host => $opt{is_virtual_host},
    );
}


main();
exit(0);
