#!/usr/bin/perl -w

use strict;

use Data::Dumper;

use FindBin;
use lib "$FindBin::Bin/../lib";
use Utils::Hosts qw(get_curr_host get_host_role get_host_info);
use Utils::Common;
use Utils::Sys qw[
    get_file_lock release_file_lock
    print_err
    handle_errors
];

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


my $DEBUG = $ENV{DEBUG};

handle_errors;

get_file_lock() or do {
    print_err("WARN: found already running script, do exit");
    exit(0);
};

print_err("Started");

update_monrun_conf();

print_err("Done");
exit(0);

sub update_monrun_conf {

    my $monrun_file_path = $Utils::Common::options->{dirs}{monitor_info} . 'monrun.conf'; # TODO move to config
    my $svn_monrun_file_path;

    my $host_role = get_host_role();

    my $monrun_conf_name = get_host_info()->{monrun_conf_name} // $host_role;
    if ($monrun_conf_name) {
        $svn_monrun_file_path = $Utils::Common::options->{dirs}{scripts} . "monitors/monrun/$monrun_conf_name.conf";
    }
    print_err("svn_monrun_file_path: $svn_monrun_file_path monrun_file_path: $monrun_file_path");
    if ($svn_monrun_file_path) {
        Utils::Sys::do_sys_cmd("ln -sfn $svn_monrun_file_path $monrun_file_path");
    } else {
        if (-l $monrun_file_path) {
            Utils::Sys::do_sys_cmd("rm $monrun_file_path");
        }
    }
}
