#!/usr/bin/perl -w
use strict;

use utf8;
use open ":utf8";

use FindBin;
use lib "$FindBin::Bin/../lib";

use BM::PrefProjSrv;
use Data::Dumper;
use Utils::Common;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

my $pid_file = $Utils::Common::options->{PrefProjSrv_params}{pid_file};
my $num_forks = 0;

for my $option (@ARGV[1..$#ARGV]) {
    my $x;

    if(($x) = $option =~ /^--forks=(\d+)$/) {
        $num_forks = $x;
    }
}

if(@ARGV < 1) {
    print_err("usage: prefprojsrv.pl (start|restart|stop)");
    exit(1);
} elsif($ARGV[0] eq "start") {
    start_server();
} elsif($ARGV[0] eq "restart") {
    stop_server();
    sleep(3);
    start_server();
} elsif($ARGV[0] eq "stop") {
    stop_server();
} else {
    print_err("usage: prefprojsrv.pl (start|restart|stop)");
    exit(1);
}

sub start_server {
    my $new_pid = fork();
    exit(0) if $new_pid;

    get_file_lock("prefprojsrv") or print_err("found already running script, do exit") and exit(0);

    handle_errors;

    my $params = $Utils::Common::options->{PrefProjSrv_params};

    $num_forks ||= $params->{num_forks};
    my $server = BM::PrefProjSrv->new({ 
        port                => $params->{port},
        min_servers         => $num_forks,
        max_servers         => $num_forks,
        max_spare_servers   => $num_forks - 1,
        child_communication => 1,
        check_for_waiting   => 60
    });
    $server->run();

    release_file_lock("prefprojsrv"); 
}

sub stop_server {
    if(!open(F, $pid_file)) {
        print_log("no pid file");
        return;
    } 

    my $pid = <F>;
    chomp $pid;
    close F;

    if(!open(F, "/proc/$pid/cmdline")) {
        print_log("server is not running");
        return;
    } 

    my $name = <F>;
    close F;

    if($name !~ /prefprojsrv\.pl/) {
        print_log("server is not running");
        return;
    }
   
    print_log("killing $pid...");
    `kill $pid`;
    my $num_attempts = 10;
    while($num_attempts && kill(0, $pid)) {
        sleep 1;
        $num_attempts--;
    }
    if(kill(0, $pid)) {
        die("can't kill $pid");
    }
    print_log("done");
}

