#!/usr/bin/perl -w
use strict;

use utf8;
use open ":utf8";

use FindBin;
use lib "$FindBin::Bin/../lib";

use BM::PrefProjSrv;
use Data::Dumper;
use Utils::Common;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

get_file_lock("prefprojsrv") or print_err("found already running script, do exit") and exit(0);

handle_errors;

my $params = $Utils::Common::options->{PrefProjSrv_params};
my $server = BM::PrefProjSrv->new({ 
    port                => $params->{port},
    min_servers         => $params->{num_forks},
    max_servers         => $params->{num_forks},
    max_spare_servers   => $params->{num_forks} - 1,
});
$server->run();

release_file_lock("prefprojsrv"); 

