#!/usr/bin/env perl
use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/lib";

use Project;
use BM::Resources;
use BM::SolomonClient;

use Utils::Sys qw(
    get_file_lock
    handle_errors
);

handle_errors();
get_file_lock() or do {
    warn "Can't get lock; exit";
    exit;
};

my $proj = Project->new;

for my $res_name (BM::Resources::get_produced_sb_resources()) {
    $proj->log("update $res_name ...");
    BM::Resources::update_resource_in_sandbox($proj, $res_name);
}

$proj->log('PUT_SB_RESOURCES_OK');
BM::SolomonClient->new()->set_success_script_finish("put-resources-to-sb");
$proj->log("all done!");

exit(0);
