#!/usr/bin/perl -w
use strict;
use utf8;

# Проставляются симлинки в broadmatching/export
use Getopt::Long;

use FindBin;
use lib "$FindBin::Bin/lib";
use Utils::Common;
use Utils::Sys qw(print_log);
use BM::Resources;
use Utils::Hosts qw(get_host_role);

my %opt;
GetOptions(\%opt, 'verbose');

my $export_dir = $Utils::Common::options->{dirs}{export};

my @files;
for my $res (get_produced_resources()) {
    my $data = $resources{$res};
    my @files_res;
    push @files_res, @{$data->{files}} if $data->{files};
    push @files_res, $data->{dir} if $data->{dir};
    if (grep { not $_ } @files_res) {
        print_log("ERROR: void resource in ($res)");
        @files_res = grep {$_} @files_res;
    }
    push @files, @files_res;
}

my %name = map { /\/([^\/]*)$/; $_ => $1 } @files;
my %seen;   # (filename => file)

# TODO логику в модуль
# проставляем симлинки
for my $file (@files) {
    my $name = $name{$file};
    if (defined $seen{$name}) {
        # Файл с таким именем уже обработан
        if ($seen{$name} ne $file) {
            # Файл с таким именем уже обработан, но путь к файлу отличается
            print_log("ERROR: name collision: $name: $file " . $seen{$file});
        }
        next;
    }
    $seen{$name} = $file;

    my $type;
    if (-f $file) {
        $type = 'file';
    } elsif (-d $file) {
        $type = 'directory';
    } else {
        print_log("ERROR: no file '$file'");
        next;
    }
    my $symlink = $export_dir.'/'.$name;
    $symlink .= '_directory' if $type eq 'directory';
    print_log("file: '$file' symlink: '$symlink'") if $opt{verbose};
    unless (-l $symlink and readlink($symlink) eq $file) {
        unlink $symlink if -e $symlink or -l $symlink;      # -e возвращает false, если symlink существует, но указывает на несуществующий файл
        symlink $file, $symlink
            or print_log("ERROR: can't create symlink $symlink -> $file")
            and next;
        print_log("created symlink: $symlink -> $file");
    }
}
