#!/bin/bash -x
set -e
# этот скрипт стартует после того, как появиться catalogia_publish.

echo "==== run"

echo "==== Create symlinks /opt/broadmatching"
for full_filename in /opt/catalogia_publish/*; do
    # skip log directory.
    if ! [[ $full_filename =~ /log$ ]]; then
        ln -sfn "$full_filename" /opt/broadmatching
    fi
done

echo "==== Create symlinks for tmpfs & logs"
ln -sfn /tmpfs /opt/broadmatching/tmpfs

# Putting logs to /ephemeral and symlinking it directly
mkdir -p /ephemeral/log
ln -sfn /ephemeral/log /opt/broadmatching/log
ln -sfn /ephemeral/log /opt/catalogia_publish/log

# Для logrotate
chmod 0755 /ephemeral/log

echo "==== Create bmhost.info"
echo "{ role => '$BM_HOSTROLE', $BM_HOSTINFO_STRING }" > /opt/broadmatching/bmhost.info
echo "$BM_HOSTINFO_JSON" > /opt/broadmatching/bmhost.info.json

echo "==== bmclient"
# TODO /home/broadmatching
mkdir -p /home/broadmatching/

chown bmclient:bmclient -R /home/broadmatching/
chown bmclient:bmclient -R /opt/broadmatching/tmpfs/
chown bmclient:bmclient -R /opt/
# TODO options for symlinks
chown bmclient:bmclient -R /opt/broadmatching/
chown bmclient:bmclient -R /opt/broadmatching/log/
chown bmclient:bmclient -R /opt/catalogia_publish/

echo "==== BM_GENDICT symlinks"
/opt/catalogia_publish/scripts/qloud/create-bm-gendicts-symlinks.pl --bm-gendicts-dir /opt/BM_GENDICT --bm-dir /opt/broadmatching

echo "==== Set crontab"
/opt/catalogia_publish/scripts/set-crontab.pl --set

echo "==== Configure runit"
/opt/catalogia_publish/scripts/reconfigure_runit.pl

echo "==== Done"

if [ -n "$QLOUD_APPLICATION" ];
then
    echo "==== Overriding nginx config in qloud"
    cp /opt/catalogia_publish/configs/nginx/bmapi-qloud-deploy-transition.conf /etc/nginx/sites-available/bmapi.conf
fi

# it is not possible to pass environment variables to runit
# so we just save them in a file which we can source from
# run scripts.
#export > /etc/envvars
export | grep '=' | grep -P 'declare -x (QLOUD_|BM_|DEPLOY_)'> /etc/envvars
echo "==== runsvdir"
exec /usr/sbin/runsvdir-start
