#!/usr/bin/perl -w

# Создаем симлинки в директории broadmatching для ресурсов BM_GENDICT (https://st.yandex-team.ru/DYNSMART-878), распакованных в отдельной директории.
# Нужно для qloud (ресурсы распаковываются в /opt/BM_GENDICT/..., для работы сервиса нужны симлинки в /opt/broadmatching)

use strict;

use Getopt::Long;
use File::Find;
use File::Spec;
use File::Basename qw[ dirname basename ];

use FindBin;
use lib "$FindBin::Bin/../lib";
use Utils::Sys qw[
    print_err
    do_sys_cmd
    handle_errors
    dir_files
];

handle_errors;

my %opt = (
    'bm-dir' => '/opt/broadmatching',
    'bm-gendicts-dir' => '/opt/BM_GENDICT',
);
GetOptions(\%opt, 'help|h', 'bm-dir=s', 'bm-gendicts-dir=s',  );
if ($opt{help}) {
    print "Create symlinks for resources from BM_GENDICT\n";
    print "Usage:   create-bm-gendicts-symlinks.pl --bm-gendicts-dir DIRECTORY --bm-dir DIRECTORY\n";
    print "Examples:\n";
    print "  create-bm-gendicts-symlinks.pl --bm-gendicts-dir /opt/BM_GENDICT --bm-dir /opt/broadmatching\n";
    print "  create-bm-gendicts-symlinks.pl --bm-gendicts-dir /home/emurav/temp/BM_GENDICT --bm-dir /home/emurav/temp/create-bm-gendicts-symlinks_out\n";
    exit(0);
}

my $bm_dir = $opt{'bm-dir'} || die "--bm-dir must be setted!";
my $bm_gendicts_dir = $opt{'bm-gendicts-dir'} || die "--bm-gendicts-dir must be setted!";

unless (-d $bm_gendicts_dir) {
    print_err("bm-gendicts-dir ($bm_gendicts_dir) is not a directory");
    exit(0); # 0, т.к. скрипт будет вызываться и для сервисов, которым не нужны ресурсы BM_GENDICT
}

for my $dir_name (dir_files($bm_gendicts_dir)) {
    my $dir = "$bm_gendicts_dir/$dir_name/rt-research/broadmatching/";
    unless (-d $dir) {
        print_err("WARN: '$dir' is not a directory");
        next;
    }
    print_err("Processing $dir ...");
    File::Find::find( {
            wanted => sub {
                my $file_path = $File::Find::name;
                return unless -f $file_path;
                my $rel_dir = File::Spec->abs2rel(dirname($file_path), $dir);
                my $filename = basename($file_path);
                print_err("Process $file_path : $rel_dir $filename");
                do_sys_cmd("mkdir -p $bm_dir/$rel_dir");
                do_sys_cmd("ln -sfn $file_path $bm_dir/$rel_dir/$filename");
            },
        },
        $dir,
    );
    ;
}
print_err("Done");

