#!/usr/bin/perl -w
use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/lib";
use Utils::Common;
use Utils::Hosts qw(get_host_role is_cur_host_in_deploy);
use Utils::Sys qw(
    configure_runit_services
    handle_errors
    print_err);
use Getopt::Long;

handle_errors();

sub print_help {
    print join("\n",
            "Usage: reconfigure_runit.pl --host_specific= --host_role=",
            "create symlink for web-config and start/stop service using runit",
            "  --help                   print this help and exit",
            "  --host_specific          iron or qloud",
            "  --host_role              host role; default value = get_host_role()",
            qq!Examples:!,
            qq!  reconfigure_runit.pl --host_specific=iron!,
            qq!  reconfigure_runit.pl --host_specific=iron --host_role=bmapi!,
        ), "\n";
}

my $opt = {};
GetOptions($opt, 'help', 'host_specific=s', 'host_role=s') or (print_help and die);

print_help and exit(0) if ($opt->{help});

my $host_specific = $opt->{host_specific};
$host_specific ||= 'deploy' if is_cur_host_in_deploy();
$host_specific ||= 'iron';
die "Set --host_specific" if (!$host_specific);

my $host_role = $opt->{host_role} //= get_host_role();
print_err("configre runit services ...");
print_err("host_role=$host_role host_specific=$host_specific");
configure_runit_services($host_role, $host_specific);
print_err("OK");
