#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use Data::Dumper;

use FindBin;
use lib "$FindBin::Bin/lib";
use lib "$FindBin::Bin/wlib";
use lib "$FindBin::Bin/cpan";

use Utils::Common;
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    fork_tasks
    rotate_files
    handle_errors
    print_err
    wait_for_file_lock
);
use CatalogiaMediaProject;
use Getopt::Long;


handle_errors();

my %opt = (
);
GetOptions(
    \%opt,
    'waitlock',
    'comptrie',
    #'Cmd=s',            # 
);

my ($cronname, $prtype) = ($ARGV[0], $ARGV[1]);
exit(0) unless $cronname;

$prtype ||= '';

my $lock_name = 'run_cron_'.$cronname;

if ($opt{waitlock}) {
    print_err("wait_for_file_lock ...");
    wait_for_file_lock($lock_name)
        or die "Could not wait_for_file_lock!";
} else {
    get_file_lock($lock_name)
        or exit(0);
}

my $proj;
if( $prtype eq 'light' ){
    $proj = CatalogiaMediaProject->new({
        load_dicts => 0,
        load_minicategs_light => 0,
        no_auth => 1,
        no_form => 1,
    });
}else{
    my %proj_par = (
        load_dicts => 1,
        load_minicategs_light => 1,
        no_auth => 1,
        no_form => 1,
        nrmsrv  => 0,
    );
    $proj_par{use_comptrie_subphraser} = 1 if $opt{comptrie};
    $proj = CatalogiaMediaProject->new(\%proj_par);
}

$proj->make_cron($cronname);
 

release_file_lock($lock_name);
exit(0);
