#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use Data::Dumper;
use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Common;
use Utils::Sys;
use File::Copy qw/ /;
use Getopt::Long;

Utils::Sys::handle_errors();

my @resource_ids = ();

my $proj = Project->new({});
my $sandbox_client = $proj->sandbox_client;

my %cmake_lists_file_to_sub = (
    $Utils::Common::options->{'dirs'}{'bin-dicts'} . '/categorization/ya.make' => sub {
        my @resources = (
            ['BROADMATCH_CATEGORIZATION_COMPTRIE', 'subphraser.comptrie'],
            ['BROADMATCH_CATEGORIES_SUPPRESSION_DICT', 'categories_suppression.szmap'],
        );
        my @lines = ();
        push(@lines, 'OWNER(g:irt)');
        push(@lines, 'UNION()');
        push(@lines, 'FROM_SANDBOX(FILE ' . $sandbox_client->get_resource_info(type => $_->[0], state => 'READY', limit => 1, order => '-id')->{'items'}[0]{'id'} . " OUT $_->[1])")
            for @resources;
        push(@lines, 'END()');

        return @lines;
    },
);

for my $cmake_lists_file (sort keys %cmake_lists_file_to_sub) {
    $proj->log("update $cmake_lists_file started");
    my $temp_file = Utils::Sys::get_tempfile('', DIR => $Utils::Common::options->{'dirs'}{'temp'}, UNLINK => 1);
    open(my $fh, '>', $temp_file) or die($!);
    my @lines = $cmake_lists_file_to_sub{$cmake_lists_file}->();
    print $fh "$_\n" for @lines;
    close($fh) or die($!);
    File::Copy::move($temp_file, $cmake_lists_file) or die($!);
    $proj->log("update $cmake_lists_file finished");
}
