#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use IO::Socket;
use IO::Handle;

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Common;
use Utils::Sys;
use File::Copy qw/ /;
use Getopt::Long;

Utils::Sys::handle_errors();

my $proj = Project->new({
    load_dicts              => 1,
    load_minicategs_light   => 1,
});

my $sandbox_params = $Utils::Common::options->{'sandbox_params'};
my $sandbox_token = $proj->sandbox_client->get_token();
my $ya = $proj->options->{ya_path};

my $categories_suppression_params = $Utils::Common::options->{'categories_suppression_params'};

my $command = join(' ',
    "$ya upload",
    $Utils::Common::options->{'categories_suppression_params'}{'szmap_dict'},
    "--type=$categories_suppression_params->{'sandbox_resource'}",
    "--user=$sandbox_params->{'user'}",
    "--token='$sandbox_token'",
    "--owner=$sandbox_params->{'owner'}",
    '--do-not-remove',
);

my $tries = 5;
my $sleep_between_tries = 120;
Utils::Sys::do_safely(
    sub { Utils::Sys::do_sys_cmd($command); },
    tries               => $tries,
    sleep_between_tries => $sleep_between_tries,
);
